/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query;

import com.mysema.query.QueryException;
import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.EBoolean;
import javax.annotation.Nullable;

public final class BooleanBuilder
extends EBoolean
implements Cloneable {
    private static final long serialVersionUID = -4129485177345542519L;
    @Nullable
    private EBoolean expr;

    @Nullable
    public static EBoolean allOf(EBoolean ... exprs) {
        EBoolean rv = null;
        for (EBoolean b : exprs) {
            rv = rv == null ? b : rv.and(b);
        }
        return rv;
    }

    @Nullable
    public static EBoolean anyOf(EBoolean ... exprs) {
        EBoolean rv = null;
        for (EBoolean b : exprs) {
            rv = rv == null ? b : rv.or(b);
        }
        return rv;
    }

    @Override
    public void accept(Visitor v) {
        if (this.expr == null) {
            throw new QueryException("CascadingBoolean has no value");
        }
        this.expr.accept(v);
    }

    @Override
    public BooleanBuilder and(@Nullable EBoolean right) {
        if (right != null) {
            this.expr = this.expr == null ? right : this.expr.and(right);
        }
        return this;
    }

    public BooleanBuilder andAnyOf(EBoolean ... args) {
        if (args.length > 0) {
            this.and(BooleanBuilder.anyOf(args));
        }
        return this;
    }

    public BooleanBuilder andNot(EBoolean right) {
        return this.and(right.not());
    }

    public BooleanBuilder clone() throws CloneNotSupportedException {
        return (BooleanBuilder)super.clone();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof EBoolean) {
            return this.expr != null ? this.expr.equals(o) : false;
        }
        return false;
    }

    @Nullable
    public EBoolean getValue() {
        return this.expr;
    }

    @Override
    public int hashCode() {
        return Boolean.class.hashCode();
    }

    public boolean hasValue() {
        return this.expr != null;
    }

    @Override
    public BooleanBuilder not() {
        if (this.expr != null) {
            this.expr = this.expr.not();
        }
        return this;
    }

    @Override
    public BooleanBuilder or(@Nullable EBoolean right) {
        if (right != null) {
            this.expr = this.expr == null ? right : this.expr.or(right);
        }
        return this;
    }

    public BooleanBuilder orAllOf(EBoolean ... args) {
        if (args.length > 0) {
            this.or(BooleanBuilder.allOf(args));
        }
        return this;
    }

    public BooleanBuilder orNot(EBoolean right) {
        return this.or(right.not());
    }
}

