/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.util;

import com.mysema.util.AnnotatedElementAdapter;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public final class PropertyUtils {
    private static final AnnotatedElement EMPTY = new AnnotatedElementAdapter(new AnnotatedElement[0]);

    private PropertyUtils() {
    }

    public static AnnotatedElement getAnnotatedElement(Class<?> beanClass, String propertyName, Class<?> propertyClass) {
        Field field = PropertyUtils.getField(beanClass, propertyName);
        Method method = PropertyUtils.getGetter(beanClass, propertyName, propertyClass);
        if (field == null || field.getAnnotations().length == 0) {
            return method != null && method.getAnnotations().length > 0 ? method : EMPTY;
        }
        if (method == null || method.getAnnotations().length == 0) {
            return field;
        }
        return new AnnotatedElementAdapter(field, method);
    }

    @Nullable
    private static Field getField(Class<?> beanClass, String propertyName) {
        while (beanClass != null && !beanClass.equals(Object.class)) {
            try {
                return beanClass.getDeclaredField(propertyName);
            }
            catch (SecurityException e) {
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            beanClass = beanClass.getSuperclass();
        }
        return null;
    }

    @Nullable
    private static Method getGetter(Class<?> beanClass, String name, Class<?> type) {
        String methodName = (type.equals(Boolean.class) ? "is" : "get") + StringUtils.capitalize((String)name);
        while (beanClass != null && !beanClass.equals(Object.class)) {
            try {
                return beanClass.getDeclaredMethod(methodName, new Class[0]);
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            beanClass = beanClass.getSuperclass();
        }
        return null;
    }
}

