/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.util;

import com.mysema.util.CodeWriter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.lang.StringEscapeUtils;

public class JavaWriter
implements Appendable,
CodeWriter {
    private final Appendable appendable;
    private String indent = "";
    private String type;

    public JavaWriter(Appendable appendable) {
        this.appendable = appendable;
    }

    @Override
    public CodeWriter annotation(Annotation annotation) throws IOException {
        this.append(this.indent).append("@" + annotation.annotationType().getName()).append("(");
        boolean first = true;
        for (Method method : annotation.annotationType().getDeclaredMethods()) {
            if (!first) {
                this.append(",");
            }
            this.append(method.getName() + "=");
            try {
                Object value = method.invoke((Object)annotation, new Object[0]);
                this.annotationConstant(value);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            first = false;
        }
        return this.append(")").nl();
    }

    private void annotationConstant(Object value) throws IOException {
        if (value instanceof Class) {
            Class clazz = (Class)value;
            if (!clazz.getPackage().getName().equals("java.lang")) {
                this.append(clazz.getName() + ".class");
            } else {
                this.append(clazz.getSimpleName() + ".class");
            }
        } else if (value instanceof Number) {
            this.append(value.toString());
        } else if (value instanceof Enum) {
            Enum enumValue = (Enum)value;
            this.append(enumValue.getDeclaringClass().getName() + "." + enumValue.name());
        } else if (value instanceof String) {
            this.append("\"" + StringEscapeUtils.escapeJava((String)value.toString()) + "\"");
        } else {
            throw new IllegalArgumentException("Unsupported annotation value : " + value);
        }
    }

    @Override
    public JavaWriter append(char c) throws IOException {
        this.appendable.append(c);
        return this;
    }

    @Override
    public JavaWriter append(CharSequence csq) throws IOException {
        this.appendable.append(csq);
        return this;
    }

    @Override
    public JavaWriter append(CharSequence csq, int start, int end) throws IOException {
        this.appendable.append(csq, start, end);
        return this;
    }

    @Override
    public CodeWriter beginClass(String simpleName, String superClass, String ... interfaces) throws IOException {
        this.append(this.indent + "public class " + simpleName);
        if (superClass != null) {
            this.append(" extends " + superClass);
        }
        if (interfaces.length > 0) {
            this.append(" implements ").params(interfaces);
        }
        this.append(" {\n\n");
        this.goIn();
        this.type = simpleName;
        if (this.type.contains("<")) {
            this.type = this.type.substring(0, this.type.indexOf(60));
        }
        return this;
    }

    @Override
    public <T> CodeWriter beginConstructor(Collection<T> parameters, Transformer<T, String> transformer) throws IOException {
        this.append(this.indent + "public " + this.type + "(").params(parameters, transformer).append(") {\n");
        return this.goIn();
    }

    @Override
    public CodeWriter beginConstructor(String ... parameters) throws IOException {
        this.append(this.indent + "public " + this.type + "(").params(parameters).append(") {\n");
        return this.goIn();
    }

    @Override
    public CodeWriter beginInterface(String simpleName, String ... interfaces) throws IOException {
        this.append(this.indent + "public interface " + simpleName);
        if (interfaces.length > 0) {
            this.append(" extends ").params(interfaces);
        }
        this.append(" {\n\n");
        this.goIn();
        this.type = simpleName;
        if (this.type.contains("<")) {
            this.type = this.type.substring(0, this.type.indexOf(60));
        }
        return this;
    }

    @Override
    public CodeWriter beginLine(String ... segments) throws IOException {
        this.append(this.indent);
        for (String segment : segments) {
            this.append(segment);
        }
        return this;
    }

    @Override
    public <T> CodeWriter beginMethod(String returnType, String methodName, Collection<T> parameters, Transformer<T, String> transformer) throws IOException {
        this.append(this.indent + "public " + returnType + " " + methodName + "(").params(parameters, transformer).append(") {\n");
        return this.goIn();
    }

    @Override
    public CodeWriter beginMethod(String returnType, String methodName, String ... args) throws IOException {
        this.append(this.indent + "public " + returnType + " " + methodName + "(").params(args).append(") {\n");
        return this.goIn();
    }

    @Override
    public <T> CodeWriter beginStaticMethod(String returnType, String methodName, Collection<T> parameters, Transformer<T, String> transformer) throws IOException {
        this.append(this.indent + "public static " + returnType + " " + methodName + "(").params(parameters, transformer).append(") {\n");
        return this.goIn();
    }

    @Override
    public CodeWriter end() throws IOException {
        this.goOut();
        return this.line("}\n");
    }

    private CodeWriter goIn() {
        this.indent = this.indent + "    ";
        return this;
    }

    private CodeWriter goOut() {
        if (this.indent.length() >= 4) {
            this.indent = this.indent.substring(0, this.indent.length() - 4);
        }
        return this;
    }

    @Override
    public CodeWriter imports(Class<?> ... imports) throws IOException {
        for (Class<?> cl : imports) {
            this.line("import " + cl.getName() + ";");
        }
        return this;
    }

    @Override
    public CodeWriter imports(Package ... imports) throws IOException {
        for (Package p : imports) {
            this.line("import " + p.getName() + ".*;");
        }
        return this;
    }

    @Override
    public CodeWriter javadoc(String ... lines) throws IOException {
        this.line("/**");
        for (String line : lines) {
            this.line(" * " + line);
        }
        return this.line(" */");
    }

    @Override
    public String join(String prefix, String suffix, Iterable<String> args) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String arg : args) {
            if (!first) {
                builder.append(", ");
            }
            builder.append(prefix).append(arg).append(suffix);
            first = false;
        }
        return builder.toString();
    }

    @Override
    public String join(String prefix, String suffix, String ... args) {
        return this.join(prefix, suffix, Arrays.asList(args));
    }

    @Override
    public CodeWriter line(String ... segments) throws IOException {
        this.append(this.indent);
        for (String segment : segments) {
            this.append(segment);
        }
        return this.append("\n");
    }

    @Override
    public CodeWriter lines(String ... lines) throws IOException {
        for (String line : lines) {
            this.line(line);
        }
        return this;
    }

    @Override
    public CodeWriter nl() throws IOException {
        return this.append("\n");
    }

    @Override
    public CodeWriter packageDecl(String packageName) throws IOException {
        return this.line("package " + packageName + ";");
    }

    private <T> CodeWriter params(Collection<T> parameters, Transformer<T, String> transformer) throws IOException {
        boolean first = true;
        for (T param : parameters) {
            if (!first) {
                this.append(", ");
            }
            this.append((CharSequence)transformer.transform(param));
            first = false;
        }
        return this;
    }

    private JavaWriter params(String ... params) throws IOException {
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                this.append(", ");
            }
            this.append(params[i]);
        }
        return this;
    }

    @Override
    public CodeWriter privateStaticFinal(String type, String name, String value) throws IOException {
        this.line("private static final " + type + " " + name + " = " + value + ";");
        return this.nl();
    }

    @Override
    public CodeWriter protectedField(String type, String name) throws IOException {
        this.line("protected " + type + " " + name + ";");
        return this.nl();
    }

    @Override
    public CodeWriter publicFinal(String type, String name) throws IOException {
        this.line("public final " + type + " " + name + ";");
        return this.nl();
    }

    @Override
    public CodeWriter publicFinal(String type, String name, String value) throws IOException {
        this.line("public final " + type + " " + name + " = " + value + ";");
        return this.nl();
    }

    @Override
    public CodeWriter publicStaticFinal(String type, String name, String value) throws IOException {
        this.line("public static final " + type + " " + name + " = " + value + ";");
        return this.nl();
    }

    @Override
    public CodeWriter staticimports(Class<?> ... imports) throws IOException {
        for (Class<?> cl : imports) {
            this.line("import static " + cl.getName() + ".*;");
        }
        return this;
    }

    @Override
    public CodeWriter suppressWarnings(String type) throws IOException {
        return this.line("@SuppressWarnings(\"" + type + "\")");
    }
}

