/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.path;

import com.mysema.query.types.expr.EBoolean;
import com.mysema.query.types.expr.Expr;
import com.mysema.query.types.operation.OBoolean;
import com.mysema.query.types.operation.Ops;
import com.mysema.query.types.path.Path;
import com.mysema.query.types.path.PathMetadata;
import com.mysema.query.types.path.PathType;
import com.mysema.util.PropertyUtils;
import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;

class PathMixin<T>
implements Path<T>,
Serializable {
    private volatile EBoolean isnull;
    private volatile EBoolean isnotnull;
    private final PathMetadata<?> metadata;
    private final Path<?> root;
    private final Expr<T> self;
    private AnnotatedElement annotatedElement;

    public PathMixin(Expr<T> self, PathMetadata<?> metadata) {
        this.self = self;
        this.metadata = metadata;
        this.root = metadata.getRoot() != null ? metadata.getRoot() : (Path)((Object)self);
    }

    @Override
    public Expr<T> asExpr() {
        return this.self;
    }

    public boolean equals(Object o) {
        return o instanceof Path ? ((Path)o).getMetadata().equals(this.metadata) : false;
    }

    @Override
    public PathMetadata<?> getMetadata() {
        return this.metadata;
    }

    @Override
    public Path<?> getRoot() {
        return this.root;
    }

    @Override
    public Class<? extends T> getType() {
        return this.self.getType();
    }

    public int hashCode() {
        return this.metadata.hashCode();
    }

    @Override
    public EBoolean isNotNull() {
        if (this.isnotnull == null) {
            this.isnotnull = OBoolean.create(Ops.IS_NOT_NULL, this.self);
        }
        return this.isnotnull;
    }

    @Override
    public EBoolean isNull() {
        if (this.isnull == null) {
            this.isnull = OBoolean.create(Ops.IS_NULL, this.self);
        }
        return this.isnull;
    }

    @Override
    public AnnotatedElement getAnnotatedElement() {
        if (this.annotatedElement == null) {
            if (this.metadata.getPathType() == PathType.PROPERTY) {
                Class<?> beanClass = this.metadata.getParent().getType();
                String propertyName = this.metadata.getExpression().toString();
                this.annotatedElement = PropertyUtils.getAnnotatedElement(beanClass, propertyName, this.self.getType());
            } else {
                this.annotatedElement = this.self.getType();
            }
        }
        return this.annotatedElement;
    }
}

