/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.path;

import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.EBoolean;
import com.mysema.query.types.expr.EMapBase;
import com.mysema.query.types.expr.Expr;
import com.mysema.query.types.path.PComparable;
import com.mysema.query.types.path.PDate;
import com.mysema.query.types.path.PDateTime;
import com.mysema.query.types.path.PNumber;
import com.mysema.query.types.path.PSimple;
import com.mysema.query.types.path.PTime;
import com.mysema.query.types.path.Path;
import com.mysema.query.types.path.PathBuilder;
import com.mysema.query.types.path.PathMetadata;
import com.mysema.query.types.path.PathMetadataFactory;
import com.mysema.query.types.path.PathMixin;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PMap<K, V, E extends Expr<V>>
extends EMapBase<K, V>
implements Path<Map<K, V>> {
    private static final Set<Class<?>> typedClasses = new HashSet<Class>(Arrays.asList(PathBuilder.class, PComparable.class, PDate.class, PDateTime.class, PNumber.class, PSimple.class, PTime.class));
    private final Class<K> keyType;
    private final Path<Map<K, V>> pathMixin;
    private final Class<E> queryType;
    private transient Constructor<E> constructor;
    private final Class<V> valueType;

    public PMap(Class<? super K> keyType, Class<? super V> valueType, Class<E> queryType, PathMetadata<?> metadata) {
        super(Map.class);
        this.keyType = keyType;
        this.valueType = valueType;
        this.queryType = queryType;
        this.pathMixin = new PathMixin<Map<K, V>>(this, metadata);
    }

    protected PathMetadata<K> forMapAccess(K key) {
        return PathMetadataFactory.forMapAccess(this, key);
    }

    protected PathMetadata<K> forMapAccess(Expr<K> key) {
        return PathMetadataFactory.forMapAccess(this, key);
    }

    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }

    public PMap<K, V, E> asExpr() {
        return this;
    }

    public boolean equals(Object o) {
        return this.pathMixin.equals(o);
    }

    public E get(Expr<K> key) {
        PathMetadata<K> md = this.forMapAccess(key);
        try {
            return this.newInstance(md);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public E get(K key) {
        PathMetadata<K> md = this.forMapAccess(key);
        try {
            return this.newInstance(md);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public Class<K> getKeyType() {
        return this.keyType;
    }

    @Override
    public PathMetadata<?> getMetadata() {
        return this.pathMixin.getMetadata();
    }

    @Override
    public Path<?> getRoot() {
        return this.pathMixin.getRoot();
    }

    @Override
    public Class<V> getValueType() {
        return this.valueType;
    }

    @Override
    public int hashCode() {
        return this.pathMixin.hashCode();
    }

    @Override
    public EBoolean isNotNull() {
        return this.pathMixin.isNotNull();
    }

    @Override
    public EBoolean isNull() {
        return this.pathMixin.isNull();
    }

    @Override
    public AnnotatedElement getAnnotatedElement() {
        return this.pathMixin.getAnnotatedElement();
    }

    private E newInstance(PathMetadata<?> pm) throws Exception {
        if (this.constructor == null) {
            try {
                this.constructor = typedClasses.contains(this.queryType) ? this.queryType.getConstructor(Class.class, PathMetadata.class) : this.queryType.getConstructor(PathMetadata.class);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        if (typedClasses.contains(this.queryType)) {
            return (E)((Expr)this.constructor.newInstance(this.getValueType(), pm));
        }
        return (E)((Expr)this.constructor.newInstance(pm));
    }
}

