/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.query.types.expr.EDateOrTime;
import com.mysema.query.types.expr.ENumber;
import com.mysema.query.types.expr.Expr;
import com.mysema.query.types.operation.ONumber;
import com.mysema.query.types.operation.OTime;
import com.mysema.query.types.operation.Ops;
import java.util.Date;

public abstract class ETime<D extends Comparable>
extends EDateOrTime<D> {
    private static final ETime<Date> CURRENT_TIME = ETime.currentTime(Date.class);
    private volatile ENumber<Integer> hours;
    private volatile ENumber<Integer> minutes;
    private volatile ENumber<Integer> seconds;
    private volatile ENumber<Integer> milliseconds;

    public ETime(Class<? extends D> type) {
        super(type);
    }

    public ENumber<Integer> hour() {
        if (this.hours == null) {
            this.hours = ONumber.create(Integer.class, Ops.DateTimeOps.HOUR, this);
        }
        return this.hours;
    }

    public ENumber<Integer> minute() {
        if (this.minutes == null) {
            this.minutes = ONumber.create(Integer.class, Ops.DateTimeOps.MINUTE, this);
        }
        return this.minutes;
    }

    public ENumber<Integer> second() {
        if (this.seconds == null) {
            this.seconds = ONumber.create(Integer.class, Ops.DateTimeOps.SECOND, this);
        }
        return this.seconds;
    }

    public ENumber<Integer> milliSecond() {
        if (this.milliseconds == null) {
            this.milliseconds = ONumber.create(Integer.class, Ops.DateTimeOps.MILLISECOND, this);
        }
        return this.milliseconds;
    }

    public static ETime<Date> currentTime() {
        return CURRENT_TIME;
    }

    public static <T extends Comparable> ETime<T> currentTime(Class<T> cl) {
        return OTime.create(cl, Ops.DateTimeOps.CURRENT_TIME, new Expr[0]);
    }
}

