/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.Constant;
import com.mysema.query.types.expr.EDateTime;
import com.mysema.query.types.expr.ENumber;
import com.mysema.query.types.expr.ENumberConst;
import java.util.Calendar;
import java.util.Date;

public class EDateTimeConst
extends EDateTime<Date>
implements Constant<Date> {
    private final Calendar calendar = Calendar.getInstance();
    private final Date date;

    public static EDateTime<Date> create(Date date) {
        return new EDateTimeConst(date);
    }

    public EDateTimeConst(Date date) {
        super(Date.class);
        this.date = date;
        this.calendar.setTime(date);
    }

    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }

    @Override
    public ENumber<Integer> dayOfMonth() {
        return ENumberConst.create(this.calendar.get(5));
    }

    @Override
    public ENumber<Integer> month() {
        return ENumberConst.create(this.calendar.get(2) + 1);
    }

    @Override
    public ENumber<Integer> year() {
        return ENumberConst.create(this.calendar.get(1));
    }

    @Override
    public ENumber<Integer> yearMonth() {
        return ENumberConst.create(this.calendar.get(1) * 100 + this.calendar.get(2) + 1);
    }

    @Override
    public ENumber<Integer> dayOfWeek() {
        return ENumberConst.create(this.calendar.get(7));
    }

    @Override
    public ENumber<Integer> dayOfYear() {
        return ENumberConst.create(this.calendar.get(6));
    }

    @Override
    public ENumber<Integer> week() {
        return ENumberConst.create(this.calendar.get(3));
    }

    @Override
    public ENumber<Integer> hour() {
        return ENumberConst.create(this.calendar.get(11));
    }

    @Override
    public ENumber<Integer> minute() {
        return ENumberConst.create(this.calendar.get(12));
    }

    @Override
    public ENumber<Integer> second() {
        return ENumberConst.create(this.calendar.get(13));
    }

    @Override
    public ENumber<Integer> milliSecond() {
        return ENumberConst.create(this.calendar.get(14));
    }

    @Override
    public Date getConstant() {
        return this.date;
    }
}

