/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.Constant;
import com.mysema.query.types.expr.EDate;
import com.mysema.query.types.expr.ENumber;
import com.mysema.query.types.expr.ENumberConst;
import java.sql.Date;
import java.util.Calendar;

public class EDateConst
extends EDate<Date>
implements Constant<Date> {
    private final Date date;
    private final Calendar calendar;

    public static EDate<Date> create(Date date) {
        return new EDateConst(date);
    }

    public EDateConst(Date date) {
        super(Date.class);
        this.date = date;
        this.calendar = Calendar.getInstance();
        this.calendar.setTime(date);
    }

    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }

    @Override
    public ENumber<Integer> dayOfMonth() {
        return ENumberConst.create(this.calendar.get(5));
    }

    @Override
    public ENumber<Integer> month() {
        return ENumberConst.create(this.calendar.get(2) + 1);
    }

    @Override
    public ENumber<Integer> year() {
        return ENumberConst.create(this.calendar.get(1));
    }

    @Override
    public ENumber<Integer> yearMonth() {
        return ENumberConst.create(this.calendar.get(1) * 100 + this.calendar.get(2) + 1);
    }

    @Override
    public ENumber<Integer> dayOfWeek() {
        return ENumberConst.create(this.calendar.get(7));
    }

    @Override
    public ENumber<Integer> dayOfYear() {
        return ENumberConst.create(this.calendar.get(6));
    }

    @Override
    public ENumber<Integer> week() {
        return ENumberConst.create(this.calendar.get(3));
    }

    @Override
    public Date getConstant() {
        return this.date;
    }
}

