/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.Expr;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.ClassUtils;

public class EConstructor<D>
extends Expr<D> {
    private final List<Expr<?>> args;
    private final Class<?>[] parameterTypes;

    public static <D> EConstructor<D> create(Class<D> type, Expr<?> ... args) {
        for (Constructor<?> c : type.getConstructors()) {
            Class<?>[] paramTypes = c.getParameterTypes();
            if (paramTypes.length != args.length) continue;
            boolean found = true;
            for (int i = 0; i < paramTypes.length; ++i) {
                Class paramType = paramTypes[i];
                if (paramType.isPrimitive()) {
                    paramType = ClassUtils.primitiveToWrapper(paramType);
                }
                if (paramType.isAssignableFrom(args[i].getType())) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return new EConstructor<D>(type, paramTypes, args);
        }
        throw new IllegalArgumentException("Got no matching constructor");
    }

    public EConstructor(Class<D> type, Class<?>[] paramTypes, Expr<?> ... args) {
        super(type);
        this.parameterTypes = paramTypes;
        this.args = Collections.unmodifiableList(Arrays.asList(args));
    }

    public final List<Expr<?>> getArgs() {
        return this.args;
    }

    public final Expr<?> getArg(int index) {
        return this.args.get(index);
    }

    public Constructor<D> getJavaConstructor() {
        try {
            return this.getType().getConstructor(this.parameterTypes);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }
}

