/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types;

import com.mysema.query.types.expr.EBoolean;
import com.mysema.query.types.expr.ENumber;
import com.mysema.query.types.expr.ENumberConst;
import com.mysema.query.types.expr.EString;
import com.mysema.query.types.expr.EStringConst;
import com.mysema.query.types.expr.Expr;
import com.mysema.query.types.expr.ExprConst;
import com.mysema.query.types.operation.ONumber;
import com.mysema.query.types.operation.OSimple;
import com.mysema.query.types.operation.OString;
import com.mysema.query.types.operation.Ops;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class CaseBuilder {
    public Initial when(EBoolean b) {
        return new Initial(b);
    }

    public static class Initial {
        private final EBoolean when;

        public Initial(EBoolean b) {
            this.when = b;
        }

        public <A> Cases<A, Expr<A>> then(A constant) {
            return this.then((A)((Object)ExprConst.create(constant)));
        }

        public Cases<String, EString> then(EString expr) {
            return new Cases<String, EString>(String.class){

                @Override
                protected EString createResult(Class<String> type, Expr<String> last) {
                    return OString.create(Ops.CASE, last);
                }
            }.addCase(this.when, expr);
        }

        public <A> Cases<A, Expr<A>> then(Expr<A> expr) {
            return new Cases<A, Expr<A>>(expr.getType()){

                @Override
                protected Expr<A> createResult(Class<A> type, Expr<A> last) {
                    return OSimple.create(type, Ops.CASE, last);
                }
            }.addCase(this.when, expr);
        }

        public <A extends Number> Cases<A, ENumber<A>> then(ENumber<A> expr) {
            return new Cases<A, ENumber<A>>(expr.getType()){

                @Override
                protected ENumber<A> createResult(Class<A> type, Expr<A> last) {
                    return ONumber.create(type, Ops.CASE, last);
                }
            }.addCase(this.when, expr);
        }

        public Cases<String, EString> then(String str) {
            return this.then((Number)((Object)EStringConst.create(str)));
        }

        public <A extends Number> Cases<A, ENumber<A>> then(A num) {
            return this.then((A)((Object)ENumberConst.create(num)));
        }
    }

    public static class CaseWhen<A, Q extends Expr<A>> {
        private final EBoolean b;
        private final Cases<A, Q> cases;

        public CaseWhen(Cases<A, Q> cases, EBoolean b) {
            this.cases = cases;
            this.b = b;
        }

        public Cases<A, Q> then(A constant) {
            return this.then(ExprConst.create(constant));
        }

        public Cases<A, Q> then(Expr<A> expr) {
            return this.cases.addCase(this.b, expr);
        }
    }

    public static abstract class Cases<A, Q extends Expr<A>> {
        private final List<CaseElement<A>> cases = new ArrayList<CaseElement<A>>();
        private final Class<A> type;

        public Cases(Class<A> type) {
            this.type = type;
        }

        Cases<A, Q> addCase(EBoolean condition, Expr<A> expr) {
            this.cases.add(0, new CaseElement<A>(condition, expr));
            return this;
        }

        protected abstract Q createResult(Class<A> var1, Expr<A> var2);

        public Q otherwise(A constant) {
            return this.otherwise(ExprConst.create(constant));
        }

        public Q otherwise(Expr<A> expr) {
            this.cases.add(0, new CaseElement<A>(null, expr));
            Expr<A> last = null;
            for (CaseElement<A> element : this.cases) {
                if (last == null) {
                    last = OSimple.create(this.type, Ops.CASE_ELSE, element.target);
                    continue;
                }
                last = OSimple.create(this.type, Ops.CASE_WHEN, element.condition, element.target, last);
            }
            return this.createResult(this.type, last);
        }

        public CaseWhen<A, Q> when(EBoolean b) {
            return new CaseWhen(this, b);
        }
    }

    private static class CaseElement<A> {
        @Nullable
        final EBoolean condition;
        final Expr<A> target;

        public CaseElement(@Nullable EBoolean condition, Expr<A> target) {
            this.condition = condition;
            this.target = target;
        }
    }
}

