/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.codegen;

import com.mysema.query.annotations.PropertyType;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.jcip.annotations.Immutable;

@Immutable
public enum TypeCategory {
    SIMPLE(null, new String[0]),
    MAP(null, new String[0]),
    COLLECTION(null, new String[0]),
    LIST(COLLECTION, new String[0]),
    SET(COLLECTION, new String[0]),
    ARRAY(null, new String[0]),
    COMPARABLE(SIMPLE, new String[0]),
    BOOLEAN(COMPARABLE, Boolean.class.getName()),
    DATE(COMPARABLE, java.sql.Date.class.getName(), "org.joda.time.LocalDate"),
    DATETIME(COMPARABLE, Calendar.class.getName(), Date.class.getName(), Timestamp.class.getName(), "org.joda.time.LocalDateTime", "org.joda.time.Instant", "org.joda.time.DateTime", "org.joda.time.DateMidnight"),
    ENTITY(null, new String[0]),
    NUMERIC(COMPARABLE, new String[0]),
    STRING(COMPARABLE, String.class.getName()),
    TIME(COMPARABLE, Time.class.getName(), "org.joda.time.LocalTime");

    @Nullable
    private final TypeCategory superType;
    private final Set<String> types;

    private TypeCategory(TypeCategory superType, String ... types) {
        this.superType = superType;
        this.types = new HashSet<String>(types.length);
        for (String type : types) {
            this.types.add(type);
        }
    }

    @Nullable
    public TypeCategory getSuperType() {
        return this.superType;
    }

    public boolean supports(Class<?> cl) {
        return this.supports(cl.getName());
    }

    public boolean supports(String className) {
        return this.types.contains(className);
    }

    public boolean isSubCategoryOf(TypeCategory ancestor) {
        if (this == ancestor) {
            return true;
        }
        if (this.superType == null) {
            return false;
        }
        return this.superType == ancestor || this.superType.isSubCategoryOf(ancestor);
    }

    public static TypeCategory get(String className) {
        for (TypeCategory category : TypeCategory.values()) {
            if (!category.supports(className)) continue;
            return category;
        }
        return SIMPLE;
    }

    @Nullable
    public static TypeCategory get(PropertyType propertyType) {
        switch (propertyType) {
            case COMPARABLE: {
                return COMPARABLE;
            }
            case DATE: {
                return DATE;
            }
            case DATETIME: {
                return DATETIME;
            }
            case ENTITY: {
                return ENTITY;
            }
            case SIMPLE: {
                return SIMPLE;
            }
            case TIME: {
                return TIME;
            }
            case NONE: {
                return null;
            }
        }
        throw new IllegalArgumentException("Unsupported PropertyType " + (Object)((Object)propertyType));
    }
}

