/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.codegen;

import com.mysema.commons.lang.Assert;
import com.mysema.query.codegen.ConstructorModel;
import com.mysema.query.codegen.MethodModel;
import com.mysema.query.codegen.PropertyModel;
import com.mysema.query.codegen.TypeCategory;
import com.mysema.query.codegen.TypeModel;
import com.mysema.query.codegen.TypeModelAdapter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public final class EntityModel
extends TypeModelAdapter
implements Comparable<EntityModel> {
    private final Set<ConstructorModel> constructors = new HashSet<ConstructorModel>();
    private int escapeSuffix = 1;
    private boolean hasLists;
    private boolean hasMaps;
    private boolean hasEntityFields;
    private final Set<Annotation> annotations = new HashSet<Annotation>();
    private final Set<MethodModel> methods = new HashSet<MethodModel>();
    private final String prefix;
    private final Set<PropertyModel> properties = new TreeSet<PropertyModel>();
    @Nullable
    private EntityModel superModel;
    private final Collection<String> superTypes;
    private String uncapSimpleName;

    public EntityModel(String prefix, TypeModel typeModel) {
        this(prefix, typeModel, Collections.emptyList());
    }

    public EntityModel(String prefix, TypeModel typeModel, Collection<String> superTypes) {
        super(typeModel);
        this.prefix = (String)Assert.notNull((Object)prefix);
        this.uncapSimpleName = StringUtils.uncapitalize((String)typeModel.getSimpleName());
        this.superTypes = superTypes;
    }

    public void addConstructor(ConstructorModel co) {
        this.constructors.add(co);
    }

    public void addAnnotation(Annotation annotation) {
        this.annotations.add(annotation);
    }

    public void addMethod(MethodModel method) {
        this.methods.add(method);
    }

    public void addProperty(PropertyModel field) {
        this.properties.add(this.validateField(field));
        switch (field.getType().getCategory()) {
            case MAP: {
                this.hasMaps = true;
                break;
            }
            case LIST: {
                this.hasLists = true;
                break;
            }
            case ENTITY: {
                this.hasEntityFields = true;
            }
        }
    }

    @Override
    public int compareTo(EntityModel o) {
        return this.typeModel.getSimpleName().compareTo(o.typeModel.getSimpleName());
    }

    @Override
    public TypeCategory getCategory() {
        return TypeCategory.ENTITY;
    }

    public Set<ConstructorModel> getConstructors() {
        return this.constructors;
    }

    public String getLocalGenericName() {
        try {
            return this.typeModel.getLocalGenericName(this, new StringBuilder(), false).toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public String getLocalRawName() {
        try {
            return this.typeModel.getLocalRawName(this, new StringBuilder()).toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Set<MethodModel> getMethods() {
        return this.methods;
    }

    public TypeCategory getOriginalCategory() {
        return super.getCategory();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Set<PropertyModel> getProperties() {
        return this.properties;
    }

    @Nullable
    public EntityModel getSuperModel() {
        return this.superModel;
    }

    public Collection<String> getSuperTypes() {
        return this.superTypes;
    }

    public String getUncapSimpleName() {
        return this.uncapSimpleName;
    }

    @Override
    public boolean hasEntityFields() {
        return this.hasEntityFields;
    }

    public boolean hasLists() {
        return this.hasLists;
    }

    public boolean hasMaps() {
        return this.hasMaps;
    }

    public Set<Annotation> getAnnotations() {
        return this.annotations;
    }

    public void include(EntityModel clazz) {
        for (MethodModel method : clazz.methods) {
            this.addMethod(method);
        }
        for (PropertyModel property : clazz.properties) {
            if (property.isInherited()) continue;
            this.addProperty(property.createCopy(this));
        }
    }

    public void setSuperModel(EntityModel superModel) {
        this.superModel = superModel;
    }

    private PropertyModel validateField(PropertyModel field) {
        if (field.getName().equals(this.uncapSimpleName)) {
            this.uncapSimpleName = StringUtils.uncapitalize((String)this.typeModel.getSimpleName()) + this.escapeSuffix++;
        }
        return field;
    }
}

