/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.codegen;

import com.mysema.commons.lang.Assert;
import com.mysema.query.codegen.ConstructorModel;
import com.mysema.query.codegen.EntityModel;
import com.mysema.query.codegen.ParameterModel;
import com.mysema.query.codegen.Serializer;
import com.mysema.query.codegen.SerializerConfig;
import com.mysema.query.codegen.TypeMappings;
import com.mysema.query.types.expr.Expr;
import com.mysema.util.CodeWriter;
import com.mysema.util.JavaWriter;
import java.io.IOException;
import java.io.Writer;
import net.jcip.annotations.Immutable;
import org.apache.commons.collections15.Transformer;

@Immutable
public class DTOSerializer
implements Serializer {
    private final TypeMappings typeMappings;

    public DTOSerializer(TypeMappings typeMappings) {
        this.typeMappings = (TypeMappings)Assert.notNull((Object)typeMappings);
    }

    protected void intro(EntityModel model, CodeWriter writer) throws IOException {
        String simpleName = model.getSimpleName();
        String queryType = this.typeMappings.getPathType(model, model, false);
        String localName = model.getLocalRawName();
        writer.packageDecl(model.getPackageName());
        writer.imports(Expr.class.getPackage());
        writer.nl();
        writer.javadoc(queryType + " is a Querydsl DTO type for " + simpleName);
        writer.suppressWarnings("serial");
        writer.beginClass(queryType, "EConstructor<" + localName + ">", new String[0]);
    }

    protected void outro(EntityModel model, CodeWriter writer) throws IOException {
        writer.end();
    }

    @Override
    public void serialize(final EntityModel model, SerializerConfig serializerConfig, Writer w) throws IOException {
        JavaWriter writer = new JavaWriter(w);
        this.intro(model, writer);
        String localName = model.getLocalRawName();
        for (ConstructorModel c : model.getConstructors()) {
            writer.beginConstructor(c.getParameters(), new Transformer<ParameterModel, String>(){

                public String transform(ParameterModel p) {
                    return DTOSerializer.this.typeMappings.getExprType(p.getType(), model, false, false, true) + " " + p.getName();
                }
            });
            writer.beginLine("super(" + localName + ".class");
            writer.append(", new Class[]{");
            boolean first = true;
            for (ParameterModel p : c.getParameters()) {
                if (!first) {
                    writer.append(", ");
                }
                if (p.getType().getPrimitiveName() != null) {
                    writer.append(p.getType().getPrimitiveName() + ".class");
                } else {
                    writer = p.getType().getLocalRawName(model, writer);
                    writer.append(".class");
                }
                first = false;
            }
            writer.append("}");
            for (ParameterModel p : c.getParameters()) {
                writer.append(", " + p.getName());
            }
            writer.append(");\n");
            writer.end();
        }
        this.outro(model, writer);
    }
}

