/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.alias;

import com.mysema.query.alias.AliasFactory;
import com.mysema.query.alias.MethodType;
import com.mysema.query.types.expr.ECollection;
import com.mysema.query.types.expr.EMap;
import com.mysema.query.types.expr.Expr;
import com.mysema.query.types.path.PBoolean;
import com.mysema.query.types.path.PCollection;
import com.mysema.query.types.path.PComparable;
import com.mysema.query.types.path.PDate;
import com.mysema.query.types.path.PDateTime;
import com.mysema.query.types.path.PEntity;
import com.mysema.query.types.path.PList;
import com.mysema.query.types.path.PMap;
import com.mysema.query.types.path.PNumber;
import com.mysema.query.types.path.PSet;
import com.mysema.query.types.path.PSimple;
import com.mysema.query.types.path.PString;
import com.mysema.query.types.path.PTime;
import com.mysema.query.types.path.Path;
import com.mysema.query.types.path.PathMetadata;
import com.mysema.query.types.path.PathMetadataFactory;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.commons.lang.StringUtils;

class PropertyAccessInvocationHandler
implements MethodInterceptor {
    private final Expr<?> path;
    private final AliasFactory aliasFactory;
    private final Map<Object, Expr<?>> propToExpr = new HashMap();
    private final Map<Object, Object> propToObj = new HashMap<Object, Object>();

    public PropertyAccessInvocationHandler(Expr<?> path, AliasFactory aliasFactory) {
        this.path = path;
        this.aliasFactory = aliasFactory;
    }

    @Nullable
    private Class<?> getTypeParameter(Type type, int index) {
        if (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            Type[] targs = ptype.getActualTypeArguments();
            if (targs[index] instanceof WildcardType) {
                WildcardType wildcardType = (WildcardType)targs[index];
                return (Class)wildcardType.getUpperBounds()[0];
            }
            if (targs[index] instanceof TypeVariable) {
                return (Class)((TypeVariable)targs[index]).getGenericDeclaration();
            }
            if (targs[index] instanceof ParameterizedType) {
                return (Class)((ParameterizedType)targs[index]).getRawType();
            }
            try {
                return (Class)targs[index];
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
        Object rv = null;
        MethodType methodType = MethodType.get(method);
        if (methodType == MethodType.GETTER) {
            String ptyName = this.propertyNameForGetter(method);
            Class<?> ptyClass = method.getReturnType();
            Type genericType = method.getGenericReturnType();
            if (this.propToObj.containsKey(ptyName)) {
                rv = this.propToObj.get(ptyName);
            } else {
                PathMetadata<String> pm = PathMetadataFactory.forProperty((Path)((Object)this.path), ptyName);
                rv = this.newInstance(ptyClass, genericType, proxy, ptyName, pm);
            }
            this.aliasFactory.setCurrent(this.propToExpr.get(ptyName));
        } else if (methodType == MethodType.LIST_ACCESS) {
            List<Object> propKey = Arrays.asList(new Object[]{MethodType.LIST_ACCESS, args[0]});
            if (this.propToObj.containsKey(propKey)) {
                rv = this.propToObj.get(propKey);
            } else {
                PathMetadata<Integer> pm = PathMetadataFactory.forListAccess((PList)this.path, (Integer)args[0]);
                Class elementType = ((ECollection)((Object)this.path)).getElementType();
                rv = elementType != null ? this.newInstance(elementType, elementType, proxy, propKey, pm) : this.newInstance(method.getReturnType(), method.getGenericReturnType(), proxy, propKey, pm);
            }
            this.aliasFactory.setCurrent(this.propToExpr.get(propKey));
        } else if (methodType == MethodType.MAP_ACCESS) {
            List<Object> propKey = Arrays.asList(new Object[]{MethodType.MAP_ACCESS, args[0]});
            if (this.propToObj.containsKey(propKey)) {
                rv = this.propToObj.get(propKey);
            } else {
                PathMetadata<Object> pm = PathMetadataFactory.forMapAccess((PMap)this.path, args[0]);
                Class valueType = ((EMap)((Object)this.path)).getValueType();
                rv = valueType != null ? this.newInstance(valueType, valueType, proxy, propKey, pm) : this.newInstance(method.getReturnType(), method.getGenericReturnType(), proxy, propKey, pm);
            }
            this.aliasFactory.setCurrent(this.propToExpr.get(propKey));
        } else if (methodType == MethodType.TO_STRING) {
            rv = this.path.toString();
        } else if (methodType == MethodType.HASH_CODE) {
            rv = this.path.hashCode();
        } else if (methodType == MethodType.GET_MAPPED_PATH) {
            rv = this.path;
        } else {
            throw new IllegalArgumentException("Invocation of " + method.getName() + " not supported");
        }
        return rv;
    }

    @Nullable
    private <T> T newInstance(Class<T> type, Type genericType, Object parent, Object propKey, PathMetadata<?> pm) {
        Comparable<Integer> rv;
        Expr path;
        if (String.class.equals(type)) {
            path = new PString(pm);
            rv = null;
        } else if (Integer.class.equals(type) || Integer.TYPE.equals(type)) {
            path = new PNumber<Integer>(Integer.class, pm);
            rv = 42;
        } else if (java.util.Date.class.equals(type)) {
            path = new PDateTime<java.util.Date>(java.util.Date.class, pm);
            rv = new java.util.Date();
        } else if (Timestamp.class.equals(type)) {
            path = new PDateTime<Timestamp>(Timestamp.class, pm);
            rv = new Timestamp(System.currentTimeMillis());
        } else if (Date.class.equals(type)) {
            path = new PDate<Date>(Date.class, pm);
            rv = new Date(System.currentTimeMillis());
        } else if (Time.class.equals(type)) {
            path = new PTime<Time>(Time.class, pm);
            rv = new Time(System.currentTimeMillis());
        } else if (Long.class.equals(type) || Long.TYPE.equals(type)) {
            path = new PNumber<Long>(Long.class, pm);
            rv = 42L;
        } else if (Short.class.equals(type) || Short.TYPE.equals(type)) {
            path = new PNumber<Short>(Short.class, pm);
            rv = (short)42;
        } else if (Double.class.equals(type) || Double.TYPE.equals(type)) {
            path = new PNumber<Double>(Double.class, pm);
            rv = 42.0;
        } else if (Float.class.equals(type) || Float.TYPE.equals(type)) {
            path = new PNumber<Float>(Float.class, pm);
            rv = Float.valueOf(42.0f);
        } else if (BigInteger.class.equals(type)) {
            path = new PNumber<BigInteger>(BigInteger.class, pm);
            rv = BigInteger.valueOf(42L);
        } else if (BigDecimal.class.equals(type)) {
            path = new PNumber<BigDecimal>(BigDecimal.class, pm);
            rv = BigDecimal.valueOf(42.0);
        } else if (Boolean.class.equals(type) || Boolean.TYPE.equals(type)) {
            path = new PBoolean(pm);
            rv = Boolean.TRUE;
        } else if (List.class.isAssignableFrom(type)) {
            Class<?> elementType = this.getTypeParameter(genericType, 0);
            path = new PList<Object, PEntity<Object>>(elementType, PEntity.class, pm){

                @Override
                public PEntity get(Expr<Integer> index) {
                    return new PEntity(this.elementType, this.forListAccess(index));
                }

                @Override
                public PEntity get(int index) {
                    return new PEntity(this.elementType, this.forListAccess(index));
                }
            };
            rv = this.aliasFactory.createAliasForProperty(type, parent, path);
        } else if (Set.class.isAssignableFrom(type)) {
            Class<?> elementType = this.getTypeParameter(genericType, 0);
            path = new PSet(elementType, elementType.getName(), pm);
            rv = this.aliasFactory.createAliasForProperty(type, parent, path);
        } else if (Collection.class.isAssignableFrom(type)) {
            Class<?> elementType = this.getTypeParameter(genericType, 0);
            path = new PCollection(elementType, elementType.getSimpleName(), pm);
            rv = this.aliasFactory.createAliasForProperty(type, parent, path);
        } else if (Map.class.isAssignableFrom(type)) {
            Class<?> keyType = this.getTypeParameter(genericType, 0);
            final Class<?> valueType = this.getTypeParameter(genericType, 1);
            path = new PMap<Object, Object, PEntity<Object>>(keyType, valueType, PEntity.class, pm){

                @Override
                public PEntity get(Expr<Object> key) {
                    return new PEntity(valueType, this.forMapAccess(key));
                }

                @Override
                public PEntity get(Object key) {
                    return new PEntity(valueType, this.forMapAccess(key));
                }
            };
            rv = this.aliasFactory.createAliasForProperty(type, parent, path);
        } else if (Enum.class.isAssignableFrom(type)) {
            path = new PSimple<T>(type, pm);
            rv = type.getEnumConstants()[0];
        } else {
            path = Comparable.class.isAssignableFrom(type) ? new PComparable<T>(type, pm) : new PEntity<T>(type, pm);
            rv = !Modifier.isFinal(type.getModifiers()) ? this.aliasFactory.createAliasForProperty(type, parent, path) : null;
        }
        this.propToObj.put(propKey, rv);
        this.propToExpr.put(propKey, path);
        return (T)rv;
    }

    private String propertyNameForGetter(Method method) {
        String name = method.getName();
        name = name.startsWith("is") ? name.substring(2) : name.substring(3);
        return StringUtils.uncapitalize((String)name);
    }
}

