/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.path;

import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.EArray;
import com.mysema.query.types.expr.EBoolean;
import com.mysema.query.types.expr.ENumber;
import com.mysema.query.types.expr.Expr;
import com.mysema.query.types.operation.ONumber;
import com.mysema.query.types.operation.Ops;
import com.mysema.query.types.path.PSimple;
import com.mysema.query.types.path.Path;
import com.mysema.query.types.path.PathMetadata;
import com.mysema.query.types.path.PathMetadataFactory;
import com.mysema.query.types.path.PathMixin;
import java.lang.reflect.Array;
import javax.annotation.Nonnegative;

public class PArray<E>
extends Expr<E[]>
implements Path<E[]>,
EArray<E> {
    private final Class<E[]> arrayType;
    private final Class<E> componentType;
    private final Path<E[]> pathMixin;
    private volatile ENumber<Integer> size;

    public PArray(Class<? super E> type, PathMetadata<?> metadata) {
        super(Object[].class);
        this.pathMixin = new PathMixin<E[]>(this, metadata);
        this.arrayType = Array.newInstance(type, 0).getClass();
        this.componentType = type;
    }

    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }

    @Override
    public Expr<E[]> asExpr() {
        return this;
    }

    public boolean equals(Object o) {
        return this.pathMixin.equals(o);
    }

    @Override
    public PSimple<E> get(Expr<Integer> index) {
        PathMetadata<Integer> md = PathMetadataFactory.forArrayAccess(this, index);
        return new PSimple<E>(this.componentType, md);
    }

    @Override
    public PSimple<E> get(@Nonnegative int index) {
        PathMetadata<Integer> md = PathMetadataFactory.forArrayAccess(this, index);
        return new PSimple<E>(this.componentType, md);
    }

    public Class<E> getElementType() {
        return this.componentType;
    }

    @Override
    public PathMetadata<?> getMetadata() {
        return this.pathMixin.getMetadata();
    }

    @Override
    public Path<?> getRoot() {
        return this.pathMixin.getRoot();
    }

    @Override
    public Class<E[]> getType() {
        return this.arrayType;
    }

    @Override
    public int hashCode() {
        return this.pathMixin.hashCode();
    }

    @Override
    public EBoolean isNotNull() {
        return this.pathMixin.isNotNull();
    }

    @Override
    public EBoolean isNull() {
        return this.pathMixin.isNull();
    }

    @Override
    public ENumber<Integer> size() {
        if (this.size == null) {
            this.size = ONumber.create(Integer.class, Ops.ARRAY_SIZE, this);
        }
        return this.size;
    }
}

