/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.commons.lang.Assert;
import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.Constant;
import com.mysema.query.types.expr.EBoolean;
import com.mysema.query.types.expr.EBooleanConst;
import com.mysema.query.types.expr.ENumber;
import com.mysema.query.types.expr.ENumberConst;
import com.mysema.query.types.expr.EString;
import com.mysema.query.types.expr.Expr;
import com.mysema.query.types.expr.ExprConst;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class EStringConst
extends EString
implements Constant<String> {
    private static final Map<String, EString> cache;
    private final String constant;
    private volatile ENumber<Long> length;
    private volatile EString lower;
    private volatile EString trim;
    private volatile EString upper;

    public static final EString create(String str) {
        return EStringConst.create(str, false);
    }

    public static EString create(String str, boolean populateCache) {
        if (cache.containsKey(str)) {
            return cache.get(str);
        }
        EStringConst rv = new EStringConst((String)Assert.notNull((Object)str));
        if (populateCache) {
            cache.put(str, rv);
        }
        return rv;
    }

    EStringConst(String constant) {
        this.constant = constant;
    }

    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }

    @Override
    public EString append(Expr<String> s) {
        if (s instanceof Constant) {
            return this.append((String)((Constant)((Object)s)).getConstant());
        }
        return super.append(s);
    }

    @Override
    public EString append(String s) {
        return EStringConst.create(this.constant + s);
    }

    @Override
    public Expr<Character> charAt(int i) {
        return ExprConst.create(Character.valueOf(this.constant.charAt(i)));
    }

    @Override
    public EString concat(String s) {
        return this.append(s);
    }

    @Override
    public EBoolean eq(String s) {
        return EBooleanConst.create(this.constant.equals(s));
    }

    public boolean equals(Object o) {
        return o instanceof Constant ? ((Constant)o).getConstant().equals(this.constant) : false;
    }

    @Override
    public EBoolean equalsIgnoreCase(String str) {
        return EBooleanConst.create(this.constant.equalsIgnoreCase(str));
    }

    @Override
    public String getConstant() {
        return this.constant;
    }

    @Override
    public int hashCode() {
        return this.constant.hashCode();
    }

    @Override
    public EBoolean isEmpty() {
        return EBooleanConst.create(this.constant.isEmpty());
    }

    @Override
    public EBoolean isNotEmpty() {
        return EBooleanConst.create(!this.constant.isEmpty());
    }

    @Override
    public ENumber<Long> length() {
        if (this.length == null) {
            this.length = ENumberConst.create(Long.valueOf(this.constant.length()));
        }
        return this.length;
    }

    @Override
    public EString lower() {
        if (this.lower == null) {
            this.lower = EStringConst.create(this.constant.toLowerCase());
        }
        return this.lower;
    }

    @Override
    public EBoolean matches(String pattern) {
        return EBooleanConst.create(this.constant.matches(pattern));
    }

    @Override
    public EBoolean ne(String s) {
        return EBooleanConst.create(!this.constant.equals(s));
    }

    @Override
    public EString prepend(Expr<String> s) {
        if (s instanceof Constant) {
            return this.prepend((String)((Constant)((Object)s)).getConstant());
        }
        return super.prepend(s);
    }

    @Override
    public EString prepend(String s) {
        return EStringConst.create(s + this.constant);
    }

    @Override
    public Expr<String[]> split(String regex) {
        return ExprConst.create(this.constant.split(regex));
    }

    @Override
    public EString substring(int beginIndex) {
        return EStringConst.create(this.constant.substring(beginIndex));
    }

    @Override
    public EString substring(int beginIndex, int endIndex) {
        return EStringConst.create(this.constant.substring(beginIndex, endIndex));
    }

    @Override
    public EString toLowerCase() {
        return this.lower();
    }

    @Override
    public EString toUpperCase() {
        return this.upper();
    }

    @Override
    public EString trim() {
        if (this.trim == null) {
            this.trim = EStringConst.create(this.constant.trim());
        }
        return this.trim;
    }

    @Override
    public EString upper() {
        if (this.upper == null) {
            this.upper = EStringConst.create(this.constant.toUpperCase());
        }
        return this.upper;
    }

    static {
        ArrayList<String> strs = new ArrayList<String>(Arrays.asList("", ".", ".*", "%"));
        for (int i = 0; i < 256; ++i) {
            strs.add(String.valueOf(i));
        }
        cache = new HashMap<String, EString>(strs.size());
        for (String str : strs) {
            cache.put(str, new EStringConst(str));
        }
    }
}

