/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.query.types.expr.EDateOrTime;
import com.mysema.query.types.expr.ENumber;
import com.mysema.query.types.expr.Expr;
import com.mysema.query.types.operation.ODateTime;
import com.mysema.query.types.operation.ONumber;
import com.mysema.query.types.operation.Ops;
import java.util.Date;

public abstract class EDateTime<D extends Comparable>
extends EDateOrTime<D> {
    private static final EDateTime<Date> CURRENT_DATE = EDateTime.currentDate(Date.class);
    private static final EDateTime<Date> CURRENT_TIMESTAMP = EDateTime.currentTimestamp(Date.class);
    private volatile ENumber<Integer> dayOfMonth;
    private volatile ENumber<Integer> dayOfWeek;
    private volatile ENumber<Integer> dayOfYear;
    private volatile ENumber<Integer> year;
    private volatile ENumber<Integer> month;
    private volatile ENumber<Integer> week;
    private volatile ENumber<Integer> hours;
    private volatile ENumber<Integer> minutes;
    private volatile ENumber<Integer> seconds;
    private volatile ENumber<Integer> milliseconds;
    private volatile ENumber<Integer> yearMonth;

    public static EDateTime<Date> currentDate() {
        return CURRENT_DATE;
    }

    public static <T extends Comparable> EDateTime<T> currentDate(Class<T> cl) {
        return ODateTime.create(cl, Ops.DateTimeOps.CURRENT_DATE, new Expr[0]);
    }

    public static EDateTime<Date> currentTimestamp() {
        return CURRENT_TIMESTAMP;
    }

    public static <T extends Comparable> EDateTime<T> currentTimestamp(Class<T> cl) {
        return ODateTime.create(cl, Ops.DateTimeOps.CURRENT_TIMESTAMP, new Expr[0]);
    }

    public EDateTime(Class<? extends D> type) {
        super(type);
    }

    public ENumber<Integer> dayOfMonth() {
        if (this.dayOfMonth == null) {
            this.dayOfMonth = ONumber.create(Integer.class, Ops.DateTimeOps.DAY_OF_MONTH, this);
        }
        return this.dayOfMonth;
    }

    public ENumber<Integer> dayOfWeek() {
        if (this.dayOfWeek == null) {
            this.dayOfWeek = ONumber.create(Integer.class, Ops.DateTimeOps.DAY_OF_WEEK, this);
        }
        return this.dayOfWeek;
    }

    public ENumber<Integer> dayOfYear() {
        if (this.dayOfYear == null) {
            this.dayOfYear = ONumber.create(Integer.class, Ops.DateTimeOps.DAY_OF_YEAR, this);
        }
        return this.dayOfYear;
    }

    public ENumber<Integer> hour() {
        if (this.hours == null) {
            this.hours = ONumber.create(Integer.class, Ops.DateTimeOps.HOUR, this);
        }
        return this.hours;
    }

    public ENumber<Integer> milliSecond() {
        if (this.milliseconds == null) {
            this.milliseconds = ONumber.create(Integer.class, Ops.DateTimeOps.MILLISECOND, this);
        }
        return this.milliseconds;
    }

    public ENumber<Integer> minute() {
        if (this.minutes == null) {
            this.minutes = ONumber.create(Integer.class, Ops.DateTimeOps.MINUTE, this);
        }
        return this.minutes;
    }

    public ENumber<Integer> month() {
        if (this.month == null) {
            this.month = ONumber.create(Integer.class, Ops.DateTimeOps.MONTH, this);
        }
        return this.month;
    }

    public ENumber<Integer> second() {
        if (this.seconds == null) {
            this.seconds = ONumber.create(Integer.class, Ops.DateTimeOps.SECOND, this);
        }
        return this.seconds;
    }

    public ENumber<Integer> week() {
        if (this.week == null) {
            this.week = ONumber.create(Integer.class, Ops.DateTimeOps.WEEK, this);
        }
        return this.week;
    }

    public ENumber<Integer> year() {
        if (this.year == null) {
            this.year = ONumber.create(Integer.class, Ops.DateTimeOps.YEAR, this);
        }
        return this.year;
    }

    public ENumber<Integer> yearMonth() {
        if (this.yearMonth == null) {
            this.yearMonth = ONumber.create(Integer.class, Ops.DateTimeOps.YEAR_MONTH, this);
        }
        return this.yearMonth;
    }
}

