/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.Expr;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class EConstructor<D>
extends Expr<D> {
    private final List<Expr<?>> args;
    private final Class<?>[] parameterTypes;

    public EConstructor(Class<D> type, Class<?>[] paramTypes, Expr<?> ... args) {
        super(type);
        this.parameterTypes = paramTypes;
        this.args = Collections.unmodifiableList(Arrays.asList(args));
    }

    public final List<Expr<?>> getArgs() {
        return this.args;
    }

    public final Expr<?> getArg(int index) {
        return this.args.get(index);
    }

    public Constructor<D> getJavaConstructor() {
        try {
            return this.getType().getConstructor(this.parameterTypes);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }
}

