/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types;

import com.mysema.query.types.expr.ENumber;
import com.mysema.query.types.expr.ENumberConst;
import com.mysema.query.types.expr.EString;
import com.mysema.query.types.expr.EStringConst;
import com.mysema.query.types.expr.Expr;
import com.mysema.query.types.expr.ExprConst;
import com.mysema.query.types.operation.ONumber;
import com.mysema.query.types.operation.OSimple;
import com.mysema.query.types.operation.OString;
import com.mysema.query.types.operation.Ops;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class CaseForEqBuilder<D> {
    private final Expr<D> base;
    private final Expr<? extends D> other;
    private final List<CaseElement<D>> caseElements = new ArrayList<CaseElement<D>>();
    private Class<?> type;

    public CaseForEqBuilder(Expr<D> base, Expr<? extends D> other) {
        this.base = base;
        this.other = other;
    }

    public <T> Cases<T, Expr<T>> then(Expr<T> then) {
        this.type = then.getType();
        return new Cases<T, Expr<T>>(){

            @Override
            protected Expr<T> createResult(Class<T> type, Expr<T> last) {
                return OSimple.create(type, Ops.CASE_EQ, CaseForEqBuilder.this.base, last);
            }
        }.when(this.other).then(then);
    }

    public <T> Cases<T, Expr<T>> then(T then) {
        return this.then((T)((Object)ExprConst.create(then)));
    }

    public <T extends Number> Cases<T, ENumber<T>> then(T then) {
        return this.then(ENumberConst.create(then));
    }

    public <T extends Number> Cases<T, ENumber<T>> then(ENumber<T> then) {
        this.type = then.getType();
        return new Cases<T, ENumber<T>>(){

            @Override
            protected ENumber<T> createResult(Class<T> type, Expr<T> last) {
                return ONumber.create(type, Ops.CASE_EQ, CaseForEqBuilder.this.base, last);
            }
        }.when(this.other).then(then);
    }

    public Cases<String, EString> then(EString then) {
        this.type = then.getType();
        return new Cases<String, EString>(){

            @Override
            protected EString createResult(Class<String> type, Expr<String> last) {
                return OString.create(Ops.CASE_EQ, CaseForEqBuilder.this.base, last);
            }
        }.when(this.other).then(then);
    }

    public Cases<String, EString> then(String then) {
        return this.then(EStringConst.create(then));
    }

    public class CaseWhen<T, Q extends Expr<T>> {
        private final Cases<T, Q> cases;
        private final Expr<? extends D> when;

        public CaseWhen(Cases<T, Q> cases, Expr<? extends D> when) {
            this.cases = cases;
            this.when = when;
        }

        public Cases<T, Q> then(Expr<T> then) {
            CaseForEqBuilder.this.caseElements.add(0, new CaseElement(this.when, then));
            return this.cases;
        }

        public Cases<T, Q> then(T then) {
            return this.then((T)ExprConst.create(then));
        }
    }

    public abstract class Cases<T, Q extends Expr<T>> {
        public CaseWhen<T, Q> when(Expr<? extends D> when) {
            return new CaseWhen(this, when);
        }

        public CaseWhen<T, Q> when(D when) {
            return this.when((Object)ExprConst.create(when));
        }

        public Q otherwise(Expr<T> otherwise) {
            CaseForEqBuilder.this.caseElements.add(0, new CaseElement(null, otherwise));
            Expr last = null;
            for (CaseElement element : CaseForEqBuilder.this.caseElements) {
                if (last == null) {
                    last = OSimple.create(CaseForEqBuilder.this.type, Ops.CASE_EQ_ELSE, element.target);
                    continue;
                }
                last = OSimple.create(CaseForEqBuilder.this.type, Ops.CASE_EQ_WHEN, CaseForEqBuilder.this.base, element.eq, element.target, last);
            }
            return this.createResult(CaseForEqBuilder.this.type, last);
        }

        protected abstract Q createResult(Class<T> var1, Expr<T> var2);

        public Q otherwise(T otherwise) {
            return this.otherwise((T)ExprConst.create(otherwise));
        }
    }

    private static class CaseElement<D> {
        @Nullable
        final Expr<? extends D> eq;
        final Expr<?> target;

        public CaseElement(@Nullable Expr<? extends D> eq, Expr<?> target) {
            this.eq = eq;
            this.target = target;
        }
    }
}

