/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.support;

import com.mysema.query.Projectable;
import com.mysema.query.QueryBase;
import com.mysema.query.QueryMixin;
import com.mysema.query.SearchResults;
import com.mysema.query.types.expr.Expr;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections15.IteratorUtils;

public abstract class ProjectableQuery<SubType extends ProjectableQuery<SubType>>
extends QueryBase<SubType>
implements Projectable {
    public ProjectableQuery(QueryMixin<SubType> queryMixin) {
        super(queryMixin);
    }

    protected <A> A[] asArray(A[] target, A first, A second, A ... rest) {
        target[0] = first;
        target[1] = second;
        System.arraycopy(rest, 0, target, 2, rest.length);
        return target;
    }

    @Override
    public long countDistinct() {
        this.queryMixin.setDistinct(true);
        return this.count();
    }

    @Override
    public final Iterator<Object[]> iterateDistinct(Expr<?> first, Expr<?> second, Expr<?> ... rest) {
        this.queryMixin.setDistinct(true);
        return this.iterate(first, second, rest);
    }

    @Override
    public final <RT> Iterator<RT> iterateDistinct(Expr<RT> projection) {
        this.queryMixin.setDistinct(true);
        return this.iterate(projection);
    }

    @Override
    public List<Object[]> list(Expr<?> first, Expr<?> second, Expr<?> ... rest) {
        return IteratorUtils.toList(this.iterate(first, second, rest));
    }

    @Override
    public <RT> List<RT> list(Expr<RT> projection) {
        return IteratorUtils.toList(this.iterate(projection));
    }

    @Override
    public final List<Object[]> listDistinct(Expr<?> first, Expr<?> second, Expr<?> ... rest) {
        this.queryMixin.setDistinct(true);
        return this.list(first, second, rest);
    }

    @Override
    public final <RT> List<RT> listDistinct(Expr<RT> projection) {
        this.queryMixin.setDistinct(true);
        return this.list(projection);
    }

    @Override
    public final <RT> SearchResults<RT> listDistinctResults(Expr<RT> projection) {
        this.queryMixin.setDistinct(true);
        return this.listResults(projection);
    }

    @Override
    public final <K, V> Map<K, V> map(Expr<K> key, Expr<V> value) {
        List<Object[]> list = this.list(key, value, new Expr[0]);
        LinkedHashMap<Object, Object> results = new LinkedHashMap<Object, Object>(list.size());
        for (Object[] row : list) {
            results.put(row[0], row[1]);
        }
        return results;
    }

    @Override
    public Object[] uniqueResult(Expr<?> first, Expr<?> second, Expr<?> ... rest) {
        this.queryMixin.setUnique(true);
        Iterator<Object[]> it = this.iterate(first, second, rest);
        return it.hasNext() ? it.next() : null;
    }

    @Override
    public <RT> RT uniqueResult(Expr<RT> expr) {
        this.queryMixin.setUnique(true);
        this.limit(1L);
        Iterator<RT> it = this.iterate(expr);
        return it.hasNext() ? (RT)it.next() : null;
    }
}

