/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.support;

import com.mysema.commons.lang.Assert;
import com.mysema.query.Detachable;
import com.mysema.query.QueryMixin;
import com.mysema.query.types.expr.EBoolean;
import com.mysema.query.types.expr.Expr;
import com.mysema.query.types.operation.Ops;
import com.mysema.query.types.query.ListSubQuery;
import com.mysema.query.types.query.ObjectSubQuery;

public class DetachableMixin
implements Detachable {
    private final QueryMixin<?> queryMixin;

    public DetachableMixin(QueryMixin<?> queryMixin) {
        this.queryMixin = (QueryMixin)Assert.notNull(queryMixin);
    }

    @Override
    public ObjectSubQuery<Long> count() {
        this.queryMixin.addToProjection(Ops.AggOps.COUNT_ALL_AGG_EXPR);
        return new ObjectSubQuery<Long>(this.queryMixin.getMetadata(), Long.class);
    }

    @Override
    public ListSubQuery<Object[]> list(Expr<?> first, Expr<?> second, Expr<?> ... rest) {
        this.queryMixin.addToProjection(first, second);
        this.queryMixin.addToProjection(rest);
        return new ListSubQuery<Object[]>(this.queryMixin.getMetadata(), Object[].class);
    }

    @Override
    public <RT> ListSubQuery<RT> list(Expr<RT> projection) {
        this.queryMixin.addToProjection(projection);
        return new ListSubQuery<RT>(this.queryMixin.getMetadata(), projection.getType());
    }

    @Override
    public ObjectSubQuery<Object[]> unique(Expr<?> first, Expr<?> second, Expr<?> ... rest) {
        this.queryMixin.addToProjection(first, second);
        this.queryMixin.addToProjection(rest);
        this.queryMixin.setUnique(true);
        return new ObjectSubQuery<Object[]>(this.queryMixin.getMetadata(), Object[].class);
    }

    @Override
    public <RT> ObjectSubQuery<RT> unique(Expr<RT> projection) {
        this.queryMixin.addToProjection(projection);
        this.queryMixin.setUnique(true);
        return new ObjectSubQuery<RT>(this.queryMixin.getMetadata(), projection.getType());
    }

    @Override
    public EBoolean exists() {
        if (this.queryMixin.getMetadata().getJoins().isEmpty()) {
            throw new IllegalArgumentException("No sources given");
        }
        return this.unique(this.queryMixin.getMetadata().getJoins().get(0).getTarget()).exists();
    }

    @Override
    public EBoolean notExists() {
        return this.exists().not();
    }
}

