/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.codegen;

import com.mysema.commons.lang.Assert;
import com.mysema.query.codegen.EntityModel;
import com.mysema.query.codegen.TypeModel;
import com.mysema.util.JavaSyntaxUtils;
import java.util.Arrays;
import net.jcip.annotations.Immutable;

@Immutable
public final class PropertyModel
implements Comparable<PropertyModel> {
    private final EntityModel context;
    private final boolean inherited;
    private final String[] inits;
    private final String name;
    private final String escapedName;
    private final TypeModel type;

    public PropertyModel(EntityModel context, String name, TypeModel type, String[] inits) {
        this(context, name, type, inits, false);
    }

    public PropertyModel(EntityModel context, String name, TypeModel type, String[] inits, boolean inherited) {
        this.context = context;
        this.name = (String)Assert.notNull((Object)name);
        this.escapedName = JavaSyntaxUtils.isReserved(name) ? name + "_" : name;
        this.type = (TypeModel)Assert.notNull((Object)type);
        this.inits = inits;
        this.inherited = inherited;
    }

    @Override
    public int compareTo(PropertyModel o) {
        return this.name.compareToIgnoreCase(o.getName());
    }

    public PropertyModel createCopy(EntityModel model) {
        boolean inherited = model.getSuperModel() != null;
        return new PropertyModel(model, this.name, this.type, this.inits, inherited);
    }

    public boolean equals(Object o) {
        return o instanceof PropertyModel && this.name.equals(((PropertyModel)o).name);
    }

    public EntityModel getContext() {
        return this.context;
    }

    public String getEscapedName() {
        return this.escapedName;
    }

    public String[] getInits() {
        return this.inits;
    }

    public String getName() {
        return this.name;
    }

    public TypeModel getParameter(int i) {
        return this.type.getParameter(i);
    }

    public TypeModel getType() {
        return this.type;
    }

    public int hashCode() {
        return ((Object)Arrays.asList(this.name, this.type)).hashCode();
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public String toString() {
        return this.context.getFullName() + "." + this.name;
    }
}

