/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.codegen;

import com.mysema.commons.lang.Assert;
import com.mysema.query.codegen.ConstructorModel;
import com.mysema.query.codegen.EntityModel;
import com.mysema.query.codegen.MethodModel;
import com.mysema.query.codegen.ParameterModel;
import com.mysema.query.codegen.PropertyModel;
import com.mysema.query.codegen.Serializer;
import com.mysema.query.codegen.SerializerConfig;
import com.mysema.query.codegen.TypeCategory;
import com.mysema.query.codegen.TypeMappings;
import com.mysema.query.types.custom.Custom;
import com.mysema.query.types.expr.Expr;
import com.mysema.query.types.path.PComparable;
import com.mysema.query.types.path.PDate;
import com.mysema.query.types.path.PDateTime;
import com.mysema.query.types.path.PEntity;
import com.mysema.query.types.path.PNumber;
import com.mysema.query.types.path.PTime;
import com.mysema.query.types.path.Path;
import com.mysema.query.types.path.PathMetadataFactory;
import com.mysema.util.CodeWriter;
import com.mysema.util.JavaWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import net.jcip.annotations.Immutable;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.lang.StringEscapeUtils;

@Immutable
public class EntitySerializer
implements Serializer {
    private final TypeMappings typeMappings;

    public EntitySerializer(TypeMappings mappings) {
        this.typeMappings = (TypeMappings)Assert.notNull((Object)mappings);
    }

    protected void constructors(EntityModel model, SerializerConfig config, JavaWriter writer) throws IOException {
        String localName = model.getLocalRawName();
        String genericName = model.getLocalGenericName();
        boolean hasEntityFields = model.hasEntityFields();
        String thisOrSuper = hasEntityFields ? "this" : "super";
        this.constructorsForVariables(writer, model);
        if (!hasEntityFields) {
            writer.beginConstructor("PEntity<? extends " + genericName + "> entity");
            writer.line("super(entity.getType(),entity.getMetadata());");
            writer.end();
        }
        if (hasEntityFields) {
            writer.beginConstructor("PathMetadata<?> metadata");
            writer.line("this(metadata, metadata.isRoot() ? INITS : PathInits.DEFAULT);");
            writer.end();
        } else {
            if (!localName.equals(genericName)) {
                writer.suppressWarnings("unchecked");
            }
            writer.beginConstructor("PathMetadata<?> metadata");
            writer.line("super(", localName.equals(genericName) ? "" : "(Class)", localName, ".class, metadata);");
            writer.end();
        }
        if (hasEntityFields) {
            if (!localName.equals(genericName)) {
                writer.suppressWarnings("unchecked");
            }
            writer.beginConstructor("PathMetadata<?> metadata", "PathInits inits");
            writer.line(thisOrSuper, "(", localName.equals(genericName) ? "" : "(Class)", localName, ".class, metadata, inits);");
            writer.end();
        }
        if (hasEntityFields) {
            writer.beginConstructor("Class<? extends " + genericName + "> type", "PathMetadata<?> metadata", "PathInits inits");
            writer.line("super(type, metadata, inits);");
            this.initEntityFields(writer, config, model);
            writer.end();
        }
    }

    protected void constructorsForVariables(JavaWriter writer, EntityModel model) throws IOException {
        String thisOrSuper;
        String localName = model.getLocalRawName();
        String genericName = model.getLocalGenericName();
        boolean hasEntityFields = model.hasEntityFields();
        String string = thisOrSuper = hasEntityFields ? "this" : "super";
        if (!localName.equals(genericName)) {
            writer.suppressWarnings("unchecked");
        }
        writer.beginConstructor("String variable");
        writer.line(thisOrSuper, "(", localName.equals(genericName) ? "" : "(Class)", localName, ".class, forVariable(variable)", hasEntityFields ? ", INITS" : "", ");");
        writer.end();
    }

    protected void entityAccessor(PropertyModel field, CodeWriter writer) throws IOException {
        String queryType = this.typeMappings.getPathType(field.getType(), field.getContext(), false);
        writer.beginMethod(queryType, field.getEscapedName(), new String[0]);
        writer.lines("if (" + field.getEscapedName() + " == null){", "    " + field.getEscapedName() + " = new " + queryType + "(forProperty(\"" + field.getName() + "\"));", "}", "return " + field.getEscapedName() + ";");
        writer.end();
    }

    protected void entityField(PropertyModel field, SerializerConfig config, CodeWriter writer) throws IOException {
        String queryType = this.typeMappings.getPathType(field.getType(), field.getContext(), false);
        if (field.isInherited()) {
            writer.line("// inherited");
        }
        if (config.useEntityAccessors()) {
            writer.protectedField(queryType, field.getEscapedName());
        } else {
            writer.publicFinal(queryType, field.getEscapedName());
        }
    }

    protected boolean hasOwnEntityProperties(EntityModel model) {
        if (model.hasEntityFields()) {
            for (PropertyModel property : model.getProperties()) {
                if (property.isInherited() || property.getType().getCategory() != TypeCategory.ENTITY) continue;
                return true;
            }
        }
        return false;
    }

    protected void initEntityFields(JavaWriter writer, SerializerConfig config, EntityModel model) throws IOException {
        EntityModel superModel = model.getSuperModel();
        if (superModel != null && superModel.hasEntityFields()) {
            String superQueryType = this.typeMappings.getPathType(superModel, model, false);
            writer.line("this._super = new " + superQueryType + "(type, metadata, inits);");
        }
        for (PropertyModel field : model.getProperties()) {
            if (field.getType().getCategory() == TypeCategory.ENTITY) {
                String queryType = this.typeMappings.getPathType(field.getType(), model, false);
                if (!field.isInherited()) {
                    writer.line("this." + field.getEscapedName() + " = ", "inits.isInitialized(\"" + field.getName() + "\") ? ", "new " + queryType + "(forProperty(\"" + field.getName() + "\")", field.getType().hasEntityFields() ? ", inits.get(\"" + field.getName() + "\")" : "", ") : null;");
                    continue;
                }
                if (config.useEntityAccessors()) continue;
                writer.line("this." + field.getEscapedName() + " = ", "_super." + field.getEscapedName() + ";");
                continue;
            }
            if (!field.isInherited() || superModel == null || !superModel.hasEntityFields()) continue;
            writer.line("this." + field.getEscapedName() + " = _super." + field.getEscapedName() + ";");
        }
    }

    protected void intro(EntityModel model, SerializerConfig config, JavaWriter writer) throws IOException {
        this.introPackage(writer, model);
        this.introImports(writer, config, model);
        writer.nl();
        this.introJavadoc(writer, model);
        this.introClassHeader(writer, model);
        this.introFactoryMethods(writer, model);
        this.introInits(writer, model);
        this.introDefaultInstance(writer, model);
        if (model.getSuperModel() != null) {
            this.introSuper(writer, model);
        }
    }

    protected void introClassHeader(CodeWriter writer, EntityModel model) throws IOException {
        Class pathType;
        String queryType = this.typeMappings.getPathType(model, model, true);
        String localName = model.getLocalGenericName();
        TypeCategory category = model.getOriginalCategory();
        switch (category) {
            case COMPARABLE: {
                pathType = PComparable.class;
                break;
            }
            case DATE: {
                pathType = PDate.class;
                break;
            }
            case DATETIME: {
                pathType = PDateTime.class;
                break;
            }
            case TIME: {
                pathType = PTime.class;
                break;
            }
            case NUMERIC: {
                pathType = PNumber.class;
                break;
            }
            default: {
                pathType = PEntity.class;
            }
        }
        writer.suppressWarnings("serial");
        writer.beginClass(queryType, pathType.getSimpleName() + "<" + localName + ">", new String[0]);
    }

    protected void introDefaultInstance(CodeWriter writer, EntityModel model) throws IOException {
        String simpleName = model.getUncapSimpleName();
        String queryType = this.typeMappings.getPathType(model, model, true);
        writer.publicStaticFinal(queryType, simpleName, "new " + queryType + "(\"" + simpleName + "\")");
    }

    protected void introFactoryMethods(JavaWriter writer, final EntityModel model) throws IOException {
        String localName = model.getLocalRawName();
        String genericName = model.getLocalGenericName();
        for (ConstructorModel c : model.getConstructors()) {
            if (!localName.equals(genericName)) {
                writer.suppressWarnings("unchecked");
            }
            writer.beginStaticMethod("EConstructor<" + genericName + ">", "create", c.getParameters(), new Transformer<ParameterModel, String>(){

                public String transform(ParameterModel p) {
                    return EntitySerializer.this.typeMappings.getExprType(p.getType(), model, false, false, true) + " " + p.getName();
                }
            });
            writer.beginLine("return new EConstructor<" + genericName + ">(");
            if (!localName.equals(genericName)) {
                writer.append("(Class)");
            }
            writer.append(localName + ".class");
            writer.append(", new Class[]{");
            boolean first = true;
            for (ParameterModel p : c.getParameters()) {
                if (!first) {
                    writer.append(", ");
                }
                if (p.getType().getPrimitiveName() != null) {
                    writer.append(p.getType().getPrimitiveName() + ".class");
                } else {
                    writer = p.getType().getLocalRawName(model, writer);
                    writer.append(".class");
                }
                first = false;
            }
            writer.append("}");
            for (ParameterModel p : c.getParameters()) {
                writer.append(", " + p.getName());
            }
            writer.append(");\n");
            writer.end();
        }
    }

    protected void introImports(CodeWriter writer, SerializerConfig config, EntityModel model) throws IOException {
        writer.imports(Path.class.getPackage());
        writer.staticimports(PathMetadataFactory.class);
        if (!model.getConstructors().isEmpty() || !model.getMethods().isEmpty() || model.hasLists() && config.useListAccessors() || model.hasMaps() && config.useMapAccessors()) {
            writer.imports(Expr.class.getPackage());
        }
        if (!model.getMethods().isEmpty()) {
            writer.imports(Custom.class.getPackage());
        }
    }

    protected void introInits(JavaWriter writer, EntityModel model) throws IOException {
        if (model.hasEntityFields()) {
            ArrayList<String> inits = new ArrayList<String>();
            for (PropertyModel property : model.getProperties()) {
                if (property.getType().getCategory() != TypeCategory.ENTITY) continue;
                for (String init : property.getInits()) {
                    inits.add(property.getEscapedName() + "." + init);
                }
            }
            if (!inits.isEmpty()) {
                inits.add(0, "*");
                writer.privateStaticFinal("PathInits", "INITS", "new PathInits(" + writer.join("\"", "\"", inits) + ")");
            } else {
                writer.privateStaticFinal("PathInits", "INITS", "PathInits.DIRECT");
            }
        }
    }

    protected void introJavadoc(CodeWriter writer, EntityModel model) throws IOException {
        String simpleName = model.getSimpleName();
        String queryType = model.getPrefix() + simpleName;
        writer.javadoc(queryType + " is a Querydsl query type for " + simpleName);
    }

    protected void introPackage(CodeWriter writer, EntityModel model) throws IOException {
        writer.packageDecl(model.getPackageName());
        writer.nl();
    }

    protected void introSuper(CodeWriter writer, EntityModel model) throws IOException {
        EntityModel superModel = model.getSuperModel();
        String superQueryType = this.typeMappings.getPathType(superModel, model, false);
        if (!superModel.hasEntityFields()) {
            writer.publicFinal(superQueryType, "_super", "new " + superQueryType + "(this)");
        } else {
            writer.publicFinal(superQueryType, "_super");
        }
    }

    protected void listAccessor(PropertyModel field, CodeWriter writer) throws IOException {
        String escapedName = field.getEscapedName();
        String queryType = this.typeMappings.getPathType(field.getParameter(0), field.getContext(), false);
        writer.beginMethod(queryType, escapedName, "int index");
        writer.line("return " + escapedName + ".get(index);").end();
        writer.beginMethod(queryType, escapedName, "Expr<Integer> index");
        writer.line("return " + escapedName + ".get(index);").end();
    }

    protected void mapAccessor(PropertyModel field, CodeWriter writer) throws IOException {
        String escapedName = field.getEscapedName();
        String queryType = this.typeMappings.getPathType(field.getParameter(1), field.getContext(), false);
        String keyType = field.getParameter(0).getLocalGenericName(field.getContext(), false);
        String genericKey = field.getParameter(0).getLocalGenericName(field.getContext(), true);
        writer.beginMethod(queryType, escapedName, keyType + " key");
        writer.line("return " + escapedName + ".get(key);").end();
        writer.beginMethod(queryType, escapedName, "Expr<" + genericKey + "> key");
        writer.line("return " + escapedName + ".get(key);").end();
    }

    protected void method(final EntityModel model, MethodModel method, SerializerConfig config, JavaWriter writer) throws IOException {
        String type = this.typeMappings.getExprType(method.getReturnType(), model, false, true, false);
        writer.beginMethod(type, method.getName(), method.getParameters(), new Transformer<ParameterModel, String>(){

            public String transform(ParameterModel p) {
                return EntitySerializer.this.typeMappings.getExprType(p.getType(), model, false, false, true) + " " + p.getName();
            }
        });
        String customClass = this.typeMappings.getCustomType(method.getReturnType(), model, true);
        writer.beginLine("return " + customClass + ".create(");
        String fullName = method.getReturnType().getFullName();
        if (!fullName.equals(String.class.getName()) && !fullName.equals(Boolean.class.getName())) {
            method.getReturnType().getLocalRawName(model, writer);
            writer.append(".class, ");
        }
        writer.append("\"" + StringEscapeUtils.escapeJava((String)method.getTemplate()) + "\"");
        writer.append(", this");
        for (ParameterModel p : method.getParameters()) {
            writer.append(", " + p.getName());
        }
        writer.append(");\n");
        writer.end();
    }

    protected void outro(EntityModel model, CodeWriter writer) throws IOException {
        writer.end();
    }

    @Override
    public void serialize(EntityModel model, SerializerConfig config, Writer w) throws IOException {
        JavaWriter writer = new JavaWriter(w);
        this.intro(model, config, writer);
        this.serializeProperties(model, config, writer);
        this.constructors(model, config, writer);
        for (MethodModel method : model.getMethods()) {
            this.method(model, method, config, writer);
        }
        for (PropertyModel property : model.getProperties()) {
            TypeCategory category = property.getType().getCategory();
            if (category == TypeCategory.MAP && config.useMapAccessors()) {
                this.mapAccessor(property, writer);
                continue;
            }
            if (category == TypeCategory.LIST && config.useListAccessors()) {
                this.listAccessor(property, writer);
                continue;
            }
            if (category != TypeCategory.ENTITY || !config.useEntityAccessors()) continue;
            this.entityAccessor(property, writer);
        }
        this.outro(model, writer);
    }

    protected void serialize(PropertyModel field, String type, JavaWriter writer, String factoryMethod, String ... args) throws IOException {
        EntityModel superModel = field.getContext().getSuperModel();
        StringBuilder value = new StringBuilder();
        if (field.isInherited() && superModel != null) {
            if (!superModel.hasEntityFields()) {
                value.append("_super." + field.getEscapedName());
            }
        } else {
            value.append(factoryMethod + "(\"" + field.getName() + "\"");
            for (String arg : args) {
                value.append(", " + arg);
            }
            value.append(")");
        }
        if (field.isInherited()) {
            writer.line("//inherited");
        }
        if (value.length() > 0) {
            writer.publicFinal(type, field.getEscapedName(), value.toString());
        } else {
            writer.publicFinal(type, field.getEscapedName());
        }
    }

    private void serializeProperties(EntityModel model, SerializerConfig config, JavaWriter writer) throws IOException {
        for (PropertyModel property : model.getProperties()) {
            String queryType = this.typeMappings.getPathType(property.getType(), model, false);
            String localGenericName = property.getType().getLocalGenericName(model, true);
            String localRawName = property.getType().getLocalRawName(model);
            switch (property.getType().getCategory()) {
                case STRING: {
                    this.serialize(property, queryType, writer, "createString", new String[0]);
                    break;
                }
                case BOOLEAN: {
                    this.serialize(property, queryType, writer, "createBoolean", new String[0]);
                    break;
                }
                case SIMPLE: {
                    this.serialize(property, queryType, writer, "createSimple", localRawName + ".class");
                    break;
                }
                case COMPARABLE: {
                    this.serialize(property, queryType, writer, "createComparable", localRawName + ".class");
                    break;
                }
                case DATE: {
                    this.serialize(property, queryType, writer, "createDate", localRawName + ".class");
                    break;
                }
                case DATETIME: {
                    this.serialize(property, queryType, writer, "createDateTime", localRawName + ".class");
                    break;
                }
                case TIME: {
                    this.serialize(property, queryType, writer, "createTime", localRawName + ".class");
                    break;
                }
                case NUMERIC: {
                    this.serialize(property, queryType, writer, "createNumber", localRawName + ".class");
                    break;
                }
                case ARRAY: {
                    localGenericName = property.getParameter(0).getLocalGenericName(model, true);
                    localRawName = property.getParameter(0).getLocalRawName(model);
                    this.serialize(property, "PArray<" + localGenericName + ">", writer, "createArray", localRawName + ".class");
                    break;
                }
                case COLLECTION: {
                    localGenericName = property.getParameter(0).getLocalGenericName(model, true);
                    localRawName = property.getParameter(0).getLocalRawName(model);
                    this.serialize(property, "PCollection<" + localGenericName + ">", writer, "createCollection", localRawName + ".class");
                    break;
                }
                case SET: {
                    localGenericName = property.getParameter(0).getLocalGenericName(model, true);
                    localRawName = property.getParameter(0).getLocalRawName(model);
                    this.serialize(property, "PSet<" + localGenericName + ">", writer, "createSet", localRawName + ".class");
                    break;
                }
                case MAP: {
                    String genericKey = property.getParameter(0).getLocalGenericName(model, true);
                    String genericValue = property.getParameter(1).getLocalGenericName(model, true);
                    String genericQueryType = this.typeMappings.getPathType(property.getParameter(1), model, false);
                    String keyType = property.getParameter(0).getLocalRawName(model);
                    String valueType = property.getParameter(1).getLocalRawName(model);
                    queryType = this.typeMappings.getPathType(property.getParameter(1), model, true);
                    this.serialize(property, "PMap<" + genericKey + ", " + genericValue + ", " + genericQueryType + ">", writer, "this.<" + genericKey + ", " + genericValue + ", " + genericQueryType + ">createMap", keyType + ".class", valueType + ".class", queryType + ".class");
                    break;
                }
                case LIST: {
                    localGenericName = property.getParameter(0).getLocalGenericName(model, true);
                    String genericQueryType = this.typeMappings.getPathType(property.getParameter(0), model, false);
                    localRawName = property.getParameter(0).getLocalRawName(model);
                    queryType = this.typeMappings.getPathType(property.getParameter(0), model, true);
                    this.serialize(property, "PList<" + localGenericName + ", " + genericQueryType + ">", writer, "createList", localRawName + ".class", queryType + ".class");
                    break;
                }
                case ENTITY: {
                    this.entityField(property, config, writer);
                }
            }
        }
    }
}

