/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.codegen;

import com.mysema.query.annotations.QueryInit;
import com.mysema.query.annotations.QueryTransient;
import com.mysema.query.annotations.QueryType;
import com.mysema.query.codegen.ClassTypeModel;
import com.mysema.query.codegen.EntityModel;
import com.mysema.query.codegen.PropertyModel;
import com.mysema.query.codegen.TypeCategory;
import com.mysema.query.codegen.TypeModel;
import com.mysema.query.codegen.TypeModelFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import net.jcip.annotations.Immutable;

@Immutable
public class EntityModelFactory {
    private final Class<? extends Annotation> skipAnn;
    private final TypeModelFactory typeModelFactory;

    public EntityModelFactory(TypeModelFactory typeModelFactory) {
        this(typeModelFactory, QueryTransient.class);
    }

    public EntityModelFactory(TypeModelFactory typeModelFactory, Class<? extends Annotation> skipAnn) {
        this.typeModelFactory = typeModelFactory;
        this.skipAnn = skipAnn;
    }

    public EntityModel create(Class<?> key, String prefix) {
        ArrayList<String> superTypes;
        if (key.isInterface()) {
            superTypes = new ArrayList();
            for (Class<?> iface : key.getInterfaces()) {
                if (iface.getName().startsWith("java")) continue;
                superTypes.add(iface.getName());
            }
        } else {
            superTypes = Collections.singleton(key.getSuperclass().getName());
        }
        EntityModel entityModel = new EntityModel(prefix, new ClassTypeModel(TypeCategory.ENTITY, key), superTypes);
        for (Field f : key.getDeclaredFields()) {
            if (!this.isValidField(f)) continue;
            TypeModel typeModel = this.typeModelFactory.create(f.getType(), f.getGenericType());
            if (f.getAnnotation(QueryType.class) != null) {
                TypeCategory typeCategory = TypeCategory.get(f.getAnnotation(QueryType.class).value());
                if (typeCategory == null) continue;
                typeModel = typeModel.as(typeCategory);
            }
            String[] inits = new String[]{};
            if (f.getAnnotation(QueryInit.class) != null) {
                inits = f.getAnnotation(QueryInit.class).value();
            }
            entityModel.addProperty(new PropertyModel(entityModel, f.getName(), typeModel, inits));
        }
        return entityModel;
    }

    protected boolean isValidField(Field field) {
        return field.getAnnotation(this.skipAnn) == null && !Modifier.isTransient(field.getModifiers()) && !Modifier.isStatic(field.getModifiers());
    }
}

