/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query;

import com.mysema.query.QueryModifiers;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.jcip.annotations.Immutable;

@Immutable
public final class SearchResults<T> {
    private final long limit;
    private final long offset;
    private final long total;
    private final List<T> results;

    public static <T> SearchResults<T> emptyResults() {
        return new SearchResults(Collections.emptyList(), Long.MAX_VALUE, 0L, 0L);
    }

    public SearchResults(List<T> results, @Nullable Long limit, @Nullable Long offset, long total) {
        this.limit = limit != null ? limit : Long.MAX_VALUE;
        this.offset = offset != null ? offset : 0L;
        this.total = total;
        this.results = results;
    }

    public SearchResults(List<T> results, QueryModifiers mod, long total) {
        this(results, mod.getLimit(), mod.getOffset(), total);
    }

    public List<T> getResults() {
        return this.results;
    }

    public long getTotal() {
        return this.total;
    }

    public boolean isEmpty() {
        return this.results.isEmpty();
    }

    public long getLimit() {
        return this.limit;
    }

    public long getOffset() {
        return this.offset;
    }
}

