/*
 * Copyright (c) 2009 Mysema Ltd.
 * All rights reserved.
 * 
 */
package com.mysema.query.types.path;

import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.EBoolean;
import com.mysema.query.types.expr.EString;

/**
 * PString represents String typed paths
 * 
 * @author tiwe
 * 
 */
@SuppressWarnings("serial")
public class PString extends EString implements Path<String> {

    private final Path<String> pathMixin;
    
    public PString(Path<?> parent, String property) {
        this(PathMetadataFactory.forProperty(parent, property));
    }

    public PString(PathMetadata<?> metadata) {
        this.pathMixin = new PathMixin<String>(this, metadata);
    }
    
    public PString(String var) {
        this(PathMetadataFactory.forVariable(var));
    }

    @Override
    public void accept(Visitor v) {
        v.visit(this);        
    }
    
    @Override
    public EString asExpr() {
        return this;
    }
    
    @Override
    public boolean equals(Object o) {
        return pathMixin.equals(o);
    }
    
    @Override
    public PathMetadata<?> getMetadata() {
        return pathMixin.getMetadata();
    }

    @Override
    public Path<?> getRoot() {
        return pathMixin.getRoot();
    }

    @Override
    public int hashCode() {
        return pathMixin.hashCode();
    }

    @Override
    public EBoolean isNotNull() {
        return pathMixin.isNotNull();
    }
    
    @Override
    public EBoolean isNull() {
        return pathMixin.isNull();
    }
}