/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.serialization;

import com.mysema.commons.lang.Assert;
import com.mysema.query.BooleanBuilder;
import com.mysema.query.types.Template;
import com.mysema.query.types.Templates;
import com.mysema.query.types.VisitorBase;
import com.mysema.query.types.custom.Custom;
import com.mysema.query.types.expr.Constant;
import com.mysema.query.types.expr.EArrayConstructor;
import com.mysema.query.types.expr.EBoolean;
import com.mysema.query.types.expr.EConstructor;
import com.mysema.query.types.expr.Expr;
import com.mysema.query.types.operation.Operation;
import com.mysema.query.types.operation.Operator;
import com.mysema.query.types.path.Path;
import com.mysema.query.types.path.PathType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class SerializerBase<SubType extends SerializerBase<SubType>>
extends VisitorBase<SubType> {
    private final StringBuilder builder = new StringBuilder();
    protected Map<Object, String> constantToLabel = new HashMap<Object, String>();
    protected String constantPrefix = "a";
    protected final Templates templates;
    private final SubType _this = this;

    public SerializerBase(Templates patterns) {
        this.templates = (Templates)Assert.notNull((Object)patterns, (String)"patterns is null");
    }

    public SubType append(String ... str) {
        for (String s : str) {
            this.builder.append(s);
        }
        return this._this;
    }

    public Map<Object, String> getConstantToLabel() {
        return this.constantToLabel;
    }

    public final SubType handle(String sep, List<? extends Expr<?>> expressions) {
        boolean first = true;
        for (Expr<?> expr : expressions) {
            if (!first) {
                this.append(sep);
            }
            this.handle(expr);
            first = false;
        }
        return this._this;
    }

    public void setConstantPrefix(String prefix) {
        this.constantPrefix = prefix;
    }

    public String toString() {
        return this.builder.toString();
    }

    @Override
    public void visit(Custom<?> expr) {
        for (Template.Element element : expr.getTemplate().getElements()) {
            if (element.getStaticText() != null) {
                this.append(element.getStaticText());
                continue;
            }
            this.handle(expr.getArg(element.getIndex()));
        }
    }

    @Override
    public void visit(EArrayConstructor<?> oa) {
        ((SerializerBase)((SerializerBase)this.append("new ")).append(oa.getElementType().getName())).append("[]{");
        ((SerializerBase)this.handle(", ", oa.getArgs())).append("}");
    }

    @Override
    public void visit(Constant<?> expr) {
        if (!this.constantToLabel.containsKey(expr.getConstant())) {
            String constLabel = this.constantPrefix + (this.constantToLabel.size() + 1);
            this.constantToLabel.put(expr.getConstant(), constLabel);
            this.append(constLabel);
        } else {
            this.append(this.constantToLabel.get(expr.getConstant()));
        }
    }

    @Override
    public void visit(EConstructor<?> expr) {
        ((SerializerBase)((SerializerBase)this.append("new ")).append(expr.getType().getName())).append("(");
        ((SerializerBase)this.handle(", ", expr.getArgs())).append(")");
    }

    @Override
    public void visit(Operation<?, ?> expr) {
        this.visitOperation(expr.getType(), expr.getOperator(), expr.getArgs());
    }

    @Override
    public void visit(Path<?> path) {
        PathType pathType = path.getMetadata().getPathType();
        Template template = this.templates.getTemplate(pathType);
        ArrayList args = new ArrayList();
        if (path.getMetadata().getParent() != null) {
            args.add((Expr)((Object)path.getMetadata().getParent()));
        }
        args.add(path.getMetadata().getExpression());
        for (Template.Element element : template.getElements()) {
            if (element.getStaticText() != null) {
                this.append(element.getStaticText());
                continue;
            }
            Expr arg = (Expr)args.get(element.getIndex());
            if (element.isAsString()) {
                this.append(arg.toString());
                continue;
            }
            if (element.hasConverter()) {
                this.handle(element.convert(arg));
                continue;
            }
            this.handle(arg);
        }
    }

    protected void visitOperation(Class<?> type, Operator<?> operator, List<Expr<?>> args) {
        Template template = this.templates.getTemplate(operator);
        if (template == null) {
            throw new IllegalArgumentException("Got no pattern for " + operator);
        }
        int precedence = this.templates.getPrecedence(operator);
        for (Template.Element element : template.getElements()) {
            if (element.getStaticText() != null) {
                this.append(element.getStaticText());
                continue;
            }
            if (element.isAsString()) {
                this.append(args.get(element.getIndex()).toString());
                continue;
            }
            int i = element.getIndex();
            boolean wrap = false;
            EBoolean arg = args.get(i);
            if (arg instanceof BooleanBuilder) {
                arg = ((BooleanBuilder)arg).getValue();
            }
            if (arg instanceof Operation) {
                boolean bl = wrap = precedence < this.templates.getPrecedence(((Operation)((Object)arg)).getOperator());
            }
            if (wrap) {
                this.append("(");
            }
            if (element.hasConverter()) {
                this.handle(element.convert(arg));
            } else {
                this.handle(arg);
            }
            if (!wrap) continue;
            this.append(")");
        }
    }
}

