/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.paging;

import com.mysema.query.paging.Callback;
import com.mysema.query.paging.CallbackService;
import com.mysema.query.paging.ListSource;
import java.util.Collections;
import java.util.List;

public abstract class ListSourceBase<T>
implements ListSource<T> {
    private final CallbackService callbackService;
    private final long size;

    public ListSourceBase(CallbackService callbackService, long size) {
        this.callbackService = callbackService;
        this.size = size;
    }

    public static <T> ListSource<T> emptyResults() {
        return new ListSource<T>(){

            @Override
            public List<T> getResults(int fromIndex, int toIndex) {
                return Collections.emptyList();
            }

            @Override
            public boolean isEmpty() {
                return true;
            }

            @Override
            public long size() {
                return 0L;
            }
        };
    }

    protected abstract List<T> getInnerResults(int var1, int var2);

    @Override
    public List<T> getResults(final int fromIndex, final int toIndex) {
        return (List)this.callbackService.invoke(new Callback<List<T>>(){

            @Override
            public List<T> invoke() {
                return ListSourceBase.this.getInnerResults(fromIndex, toIndex);
            }
        });
    }

    @Override
    public final boolean isEmpty() {
        return this.size == 0L;
    }

    @Override
    public final long size() {
        return this.size;
    }
}

