/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.codegen;

import com.mysema.query.codegen.EntityModel;
import com.mysema.query.codegen.Serializer;
import com.mysema.query.codegen.TypeCategory;
import com.mysema.query.codegen.TypeModel;
import com.mysema.query.types.expr.EBoolean;
import com.mysema.query.types.expr.EComparable;
import com.mysema.query.types.expr.EDate;
import com.mysema.query.types.expr.EDateTime;
import com.mysema.query.types.expr.ENumber;
import com.mysema.query.types.expr.EString;
import com.mysema.query.types.expr.ETime;
import com.mysema.query.types.expr.Expr;
import com.mysema.query.types.path.PBoolean;
import com.mysema.query.types.path.PComparable;
import com.mysema.query.types.path.PDate;
import com.mysema.query.types.path.PDateTime;
import com.mysema.query.types.path.PNumber;
import com.mysema.query.types.path.PSimple;
import com.mysema.query.types.path.PString;
import com.mysema.query.types.path.PTime;
import com.mysema.query.types.path.Path;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractSerializer
implements Serializer {
    private final Map<TypeCategory, Class<? extends Expr>> exprType = new HashMap<TypeCategory, Class<? extends Expr>>();
    private final Map<TypeCategory, Class<? extends Path>> pathType = new HashMap<TypeCategory, Class<? extends Path>>();

    public AbstractSerializer() {
        this.pathType.put(TypeCategory.STRING, PString.class);
        this.pathType.put(TypeCategory.BOOLEAN, PBoolean.class);
        this.pathType.put(TypeCategory.COMPARABLE, PComparable.class);
        this.pathType.put(TypeCategory.DATE, PDate.class);
        this.pathType.put(TypeCategory.DATETIME, PDateTime.class);
        this.pathType.put(TypeCategory.TIME, PTime.class);
        this.pathType.put(TypeCategory.NUMERIC, PNumber.class);
        this.pathType.put(TypeCategory.ARRAY, PSimple.class);
        this.pathType.put(TypeCategory.COLLECTION, PSimple.class);
        this.pathType.put(TypeCategory.SET, PSimple.class);
        this.pathType.put(TypeCategory.LIST, PSimple.class);
        this.pathType.put(TypeCategory.MAP, PSimple.class);
        this.pathType.put(TypeCategory.SIMPLE, PSimple.class);
        this.pathType.put(TypeCategory.ENTITY, Path.class);
        this.exprType.put(TypeCategory.STRING, EString.class);
        this.exprType.put(TypeCategory.BOOLEAN, EBoolean.class);
        this.exprType.put(TypeCategory.COMPARABLE, EComparable.class);
        this.exprType.put(TypeCategory.DATE, EDate.class);
        this.exprType.put(TypeCategory.DATETIME, EDateTime.class);
        this.exprType.put(TypeCategory.TIME, ETime.class);
        this.exprType.put(TypeCategory.NUMERIC, ENumber.class);
        this.exprType.put(TypeCategory.ARRAY, Expr.class);
        this.exprType.put(TypeCategory.COLLECTION, Expr.class);
        this.exprType.put(TypeCategory.SET, Expr.class);
        this.exprType.put(TypeCategory.LIST, Expr.class);
        this.exprType.put(TypeCategory.MAP, Expr.class);
        this.exprType.put(TypeCategory.SIMPLE, Expr.class);
        this.exprType.put(TypeCategory.ENTITY, Expr.class);
    }

    @Override
    public String getPathType(TypeModel type, EntityModel model, boolean raw) {
        String typeName = this.pathType.get((Object)type.getCategory()).getSimpleName();
        return this.getQueryType(type, model, typeName, raw, false);
    }

    public String getExprType(TypeModel type, EntityModel model, boolean raw) {
        String typeName = this.exprType.get((Object)type.getCategory()).getSimpleName();
        return this.getQueryType(type, model, typeName, raw, true);
    }

    public String getQueryType(TypeModel type, EntityModel model, String typeName, boolean raw, boolean extend) {
        String localGenericName = null;
        if (raw && type.getCategory() != TypeCategory.ENTITY) {
            return typeName;
        }
        localGenericName = type.getLocalGenericName(model, true);
        if (!type.isFinal() && extend) {
            localGenericName = "? extends " + localGenericName;
        }
        switch (type.getCategory()) {
            case STRING: {
                return typeName;
            }
            case BOOLEAN: {
                return typeName;
            }
            case COMPARABLE: {
                return typeName + "<" + localGenericName + ">";
            }
            case DATE: {
                return typeName + "<" + localGenericName + ">";
            }
            case DATETIME: {
                return typeName + "<" + localGenericName + ">";
            }
            case TIME: {
                return typeName + "<" + localGenericName + ">";
            }
            case NUMERIC: {
                return typeName + "<" + localGenericName + ">";
            }
            case ARRAY: 
            case COLLECTION: 
            case SET: 
            case LIST: 
            case MAP: 
            case SIMPLE: {
                return typeName + "<" + localGenericName + ">";
            }
            case ENTITY: {
                String suffix = type.getFullName().substring(type.getPackageName().length() + 1).replace('.', '_');
                if (type.getPackageName().equals(model.getPackageName())) {
                    return model.getPrefix() + suffix;
                }
                return type.getPackageName() + "." + model.getPrefix() + suffix;
            }
        }
        throw new IllegalArgumentException("Unsupported case " + (Object)((Object)type.getCategory()));
    }
}

