/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.path;

import com.mysema.commons.lang.Assert;
import com.mysema.query.types.expr.ENumberConst;
import com.mysema.query.types.expr.EStringConst;
import com.mysema.query.types.expr.Expr;
import com.mysema.query.types.expr.ExprConst;
import com.mysema.query.types.path.PArray;
import com.mysema.query.types.path.PList;
import com.mysema.query.types.path.PMap;
import com.mysema.query.types.path.Path;
import com.mysema.query.types.path.PathType;
import com.mysema.query.util.NotEmpty;
import java.io.Serializable;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import net.jcip.annotations.Immutable;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

@Immutable
public final class PathMetadata<T>
implements Serializable {
    private static final long serialVersionUID = -1055994185028970065L;
    private final Expr<T> expression;
    private final int hashCode;
    @Nullable
    private final Path<?> parent;
    @Nullable
    private final Path<?> root;
    private final PathType pathType;

    public static PathMetadata<Integer> forArrayAccess(PArray<?> parent, Expr<Integer> index) {
        return new PathMetadata<Integer>(parent, index, PathType.ARRAYVALUE);
    }

    public static PathMetadata<Integer> forArrayAccess(PArray<?> parent, @Nonnegative int index) {
        return new PathMetadata<int>(parent, ENumberConst.create(index), PathType.ARRAYVALUE_CONSTANT);
    }

    public static PathMetadata<Integer> forListAccess(PList<?, ?> parent, Expr<Integer> index) {
        return new PathMetadata<Integer>(parent, index, PathType.LISTVALUE);
    }

    public static PathMetadata<Integer> forListAccess(PList<?, ?> parent, @Nonnegative int index) {
        return new PathMetadata<int>(parent, ENumberConst.create(index), PathType.LISTVALUE_CONSTANT);
    }

    public static <KT> PathMetadata<KT> forMapAccess(PMap<?, ?, ?> parent, Expr<KT> key) {
        return new PathMetadata<KT>(parent, key, PathType.MAPVALUE);
    }

    public static <KT> PathMetadata<KT> forMapAccess(PMap<?, ?, ?> parent, KT key) {
        return new PathMetadata<KT>(parent, ExprConst.create(key), PathType.MAPVALUE_CONSTANT);
    }

    public static PathMetadata<String> forProperty(Path<?> parent, @NotEmpty String property) {
        return new PathMetadata<String>(parent, EStringConst.create(Assert.hasLength((String)property), true), PathType.PROPERTY);
    }

    public static PathMetadata<String> forVariable(@NotEmpty String variable) {
        return new PathMetadata<String>(null, EStringConst.create(Assert.hasLength((String)variable), true), PathType.VARIABLE);
    }

    private PathMetadata(@Nullable Path<?> parent, Expr<T> expression, PathType type) {
        this.parent = parent;
        this.expression = expression;
        this.pathType = type;
        this.root = parent != null ? parent.getRoot() : null;
        this.hashCode = new HashCodeBuilder().append(expression).append(parent).append((Object)this.pathType).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        PathMetadata p = (PathMetadata)obj;
        return new EqualsBuilder().append(this.expression, p.expression).append(this.parent, p.parent).append((Object)this.pathType, (Object)p.pathType).isEquals();
    }

    public Expr<T> getExpression() {
        return this.expression;
    }

    public Path<?> getParent() {
        return this.parent;
    }

    public PathType getPathType() {
        return this.pathType;
    }

    public Path<?> getRoot() {
        return this.root;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean isRoot() {
        return this.parent == null;
    }
}

