/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.alias;

import com.mysema.query.alias.PathFactory;
import com.mysema.query.types.expr.Expr;
import com.mysema.query.types.path.PBoolean;
import com.mysema.query.types.path.PCollection;
import com.mysema.query.types.path.PComparable;
import com.mysema.query.types.path.PDate;
import com.mysema.query.types.path.PDateTime;
import com.mysema.query.types.path.PEntity;
import com.mysema.query.types.path.PList;
import com.mysema.query.types.path.PMap;
import com.mysema.query.types.path.PNumber;
import com.mysema.query.types.path.PSet;
import com.mysema.query.types.path.PString;
import com.mysema.query.types.path.PTime;
import com.mysema.query.types.path.Path;
import com.mysema.query.types.path.PathMetadata;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

class SimplePathFactory
implements PathFactory {
    private final Map<Object, Path<?>> cache = new WeakHashMap();
    private final PBoolean btrue = new PBoolean(this.createMetadata());
    private final PBoolean bfalse = new PBoolean(this.createMetadata());
    private long counter = 0L;

    SimplePathFactory() {
    }

    @Override
    public <D> Expr<D> createAny(D arg) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PBoolean createBoolean(Boolean arg) {
        return arg != false ? this.btrue : this.bfalse;
    }

    @Override
    public <D> PCollection<D> createCollection(Collection<D> arg) {
        PCollection<Object> rv;
        if (this.cache.containsKey(arg)) {
            return (PCollection)this.cache.get(arg);
        }
        if (!arg.isEmpty()) {
            Class<?> cl = arg.iterator().next().getClass();
            rv = new PCollection(cl, cl.getSimpleName(), this.createMetadata());
        } else {
            rv = new PCollection<Object>(Object.class, "Object", this.createMetadata());
        }
        this.cache.put(arg, rv);
        return rv;
    }

    private <T, P extends Path<T>> P cache(T key, P value) {
        this.cache.put(key, value);
        return value;
    }

    @Override
    public <D extends Comparable<?>> PComparable<D> createComparable(D arg) {
        if (this.cache.containsKey(arg)) {
            return (PComparable)this.cache.get(arg);
        }
        return this.cache(arg, new PComparable(arg.getClass(), this.createMetadata()));
    }

    @Override
    public <D extends Comparable> PDate<D> createDate(D arg) {
        if (this.cache.containsKey(arg)) {
            return (PDate)this.cache.get(arg);
        }
        return this.cache(arg, new PDate(arg.getClass(), this.createMetadata()));
    }

    @Override
    public <D extends Comparable> PDateTime<D> createDateTime(D arg) {
        if (this.cache.containsKey(arg)) {
            return (PDateTime)this.cache.get(arg);
        }
        return this.cache(arg, new PDateTime(arg.getClass(), this.createMetadata()));
    }

    @Override
    public <D> PEntity<D> createEntity(D arg) {
        if (this.cache.containsKey(arg)) {
            return (PEntity)this.cache.get(arg);
        }
        return this.cache(arg, new PEntity(arg.getClass(), arg.getClass().getSimpleName(), this.createMetadata()));
    }

    @Override
    public <D> PList<D, ?> createList(List<D> arg) {
        if (this.cache.containsKey(arg)) {
            return (PList)this.cache.get(arg);
        }
        final Class<Object> cl = arg.isEmpty() ? Object.class : arg.get(0).getClass();
        return this.cache(arg, new PList<D, PEntity<D>>(Object.class, Object.class.getSimpleName(), null, this.createMetadata()){

            @Override
            public PEntity get(Expr<Integer> index) {
                return new PEntity(cl, cl.getSimpleName(), PathMetadata.forListAccess(this, index));
            }

            @Override
            public PEntity get(int index) {
                return new PEntity(cl, cl.getSimpleName(), PathMetadata.forListAccess(this, index));
            }
        });
    }

    @Override
    public <K, V> PMap<K, V, ?> createMap(Map<K, V> arg) {
        if (this.cache.containsKey(arg)) {
            return (PMap)this.cache.get(arg);
        }
        if (!arg.isEmpty()) {
            Map.Entry<K, V> entry = arg.entrySet().iterator().next();
            Class<?> keyType = entry.getKey().getClass();
            final Class<?> valueType = entry.getValue().getClass();
            return this.cache(arg, new PMap<K, V, PEntity<V>>(keyType, valueType, null, this.createMetadata()){

                @Override
                public PEntity get(Expr<K> key) {
                    return new PEntity(valueType, valueType.getSimpleName(), PathMetadata.forMapAccess(this, key));
                }

                @Override
                public PEntity get(K key) {
                    return new PEntity(valueType, valueType.getSimpleName(), PathMetadata.forMapAccess(this, key));
                }
            });
        }
        return this.cache(arg, new PMap<K, V, PEntity<V>>(Object.class, Object.class, null, this.createMetadata()){

            @Override
            public PEntity get(Expr<K> key) {
                return new PEntity<Object>(Object.class, Object.class.getSimpleName(), PathMetadata.forMapAccess(this, key));
            }

            @Override
            public PEntity get(K key) {
                return new PEntity<Object>(Object.class, Object.class.getSimpleName(), PathMetadata.forMapAccess(this, key));
            }
        });
    }

    @Override
    public <D extends Number> PNumber<D> createNumber(D arg) {
        if (this.cache.containsKey(arg)) {
            return (PNumber)this.cache.get(arg);
        }
        return this.cache(arg, new PNumber(arg.getClass(), this.createMetadata()));
    }

    @Override
    public <D> PSet<D> createSet(Set<D> arg) {
        if (this.cache.containsKey(arg)) {
            return (PSet)this.cache.get(arg);
        }
        Class cl = Object.class;
        if (!arg.isEmpty()) {
            cl = arg.iterator().next().getClass();
        }
        return this.cache(arg, new PSet(cl, cl.getSimpleName(), this.createMetadata()));
    }

    @Override
    public PString createString(String arg) {
        if (this.cache.containsKey(arg)) {
            return (PString)this.cache.get(arg);
        }
        return this.cache(arg, new PString(this.createMetadata()));
    }

    @Override
    public <D extends Comparable> PTime<D> createTime(D arg) {
        if (this.cache.containsKey(arg)) {
            return (PTime)this.cache.get(arg);
        }
        return this.cache(arg, new PTime(arg.getClass(), this.createMetadata()));
    }

    private PathMetadata<String> createMetadata() {
        return PathMetadata.forVariable("v" + String.valueOf(++this.counter));
    }
}

