/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.alias;

import com.mysema.query.alias.AliasFactory;
import com.mysema.query.alias.ManagedObject;
import com.mysema.query.alias.PathFactory;
import com.mysema.query.alias.SimplePathFactory;
import com.mysema.query.types.expr.Expr;
import com.mysema.query.types.path.PBoolean;
import com.mysema.query.types.path.PCollection;
import com.mysema.query.types.path.PComparable;
import com.mysema.query.types.path.PDate;
import com.mysema.query.types.path.PDateTime;
import com.mysema.query.types.path.PEntity;
import com.mysema.query.types.path.PList;
import com.mysema.query.types.path.PMap;
import com.mysema.query.types.path.PNumber;
import com.mysema.query.types.path.PSet;
import com.mysema.query.types.path.PString;
import com.mysema.query.types.path.PTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.Immutable;

@Immutable
class AliasAwarePathFactory
implements PathFactory {
    private final AliasFactory aliasFactory;
    private final SimplePathFactory factory = new SimplePathFactory();

    public AliasAwarePathFactory(AliasFactory aliasFactory) {
        this.aliasFactory = aliasFactory;
    }

    @Override
    public <D> Expr<D> createAny(D arg) {
        Object current = this.aliasFactory.getCurrentAndReset();
        if (current != null) {
            return current;
        }
        if (arg instanceof ManagedObject) {
            return ((ManagedObject)arg).__mappedPath();
        }
        throw new IllegalArgumentException("No path mapped to " + arg);
    }

    @Override
    public PBoolean createBoolean(Boolean arg) {
        PBoolean rv = (PBoolean)this.aliasFactory.getCurrentAndReset();
        return rv != null ? rv : this.factory.createBoolean(arg);
    }

    @Override
    public <D> PCollection<D> createCollection(Collection<D> arg) {
        PCollection<D> rv = (PCollection<D>)this.aliasFactory.getCurrentAndReset();
        return rv != null ? rv : this.factory.createCollection(arg);
    }

    @Override
    public <D> PSet<D> createSet(Set<D> arg) {
        PSet<D> rv = (PSet<D>)this.aliasFactory.getCurrentAndReset();
        return rv != null ? rv : this.factory.createSet(arg);
    }

    @Override
    public <D extends Comparable<?>> PComparable<D> createComparable(D arg) {
        PComparable<D> rv = (PComparable<D>)this.aliasFactory.getCurrentAndReset();
        return rv != null ? rv : this.factory.createComparable(arg);
    }

    @Override
    public <D extends Comparable> PDate<D> createDate(D arg) {
        PDate<D> rv = (PDate<D>)this.aliasFactory.getCurrentAndReset();
        return rv != null ? rv : this.factory.createDate(arg);
    }

    @Override
    public <D extends Comparable> PDateTime<D> createDateTime(D arg) {
        PDateTime<D> rv = (PDateTime<D>)this.aliasFactory.getCurrentAndReset();
        return rv != null ? rv : this.factory.createDateTime(arg);
    }

    @Override
    public <D> PEntity<D> createEntity(D arg) {
        PEntity rv = (PEntity)this.aliasFactory.getCurrentAndReset();
        if (rv != null) {
            return rv;
        }
        if (arg instanceof ManagedObject) {
            return ((ManagedObject)arg).__mappedPath();
        }
        return this.factory.createEntity(arg);
    }

    @Override
    public <D> PList<D, ?> createList(List<D> arg) {
        PList<D, ?> rv = (PList<D, ?>)this.aliasFactory.getCurrentAndReset();
        return rv != null ? rv : this.factory.createList(arg);
    }

    @Override
    public <K, V> PMap<K, V, ?> createMap(Map<K, V> arg) {
        PMap<K, V, ?> rv = (PMap<K, V, ?>)this.aliasFactory.getCurrentAndReset();
        return rv != null ? rv : this.factory.createMap(arg);
    }

    @Override
    public <D extends Number> PNumber<D> createNumber(D arg) {
        PNumber<D> rv = (PNumber<D>)this.aliasFactory.getCurrentAndReset();
        return rv != null ? rv : this.factory.createNumber(arg);
    }

    @Override
    public PString createString(String arg) {
        PString rv = (PString)this.aliasFactory.getCurrentAndReset();
        return rv != null ? rv : this.factory.createString(arg);
    }

    @Override
    public <D extends Comparable> PTime<D> createTime(D arg) {
        PTime<D> rv = (PTime<D>)this.aliasFactory.getCurrentAndReset();
        return rv != null ? rv : this.factory.createTime(arg);
    }
}

