/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query;

import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.EBoolean;
import javax.annotation.Nullable;

public class BooleanBuilder
extends EBoolean {
    @Nullable
    private EBoolean expr;

    @Override
    public BooleanBuilder and(EBoolean right) {
        this.expr = this.expr == null ? right : this.expr.and(right);
        return this;
    }

    public BooleanBuilder andAnyOf(EBoolean ... args) {
        if (args.length > 0) {
            EBoolean any = args[0];
            for (int i = 1; i < args.length; ++i) {
                any = any.or(args[i]);
            }
            this.and(any);
        }
        return this;
    }

    public BooleanBuilder not(EBoolean right) {
        return this.and(right.not());
    }

    @Override
    public BooleanBuilder or(EBoolean right) {
        this.expr = this.expr == null ? right : this.expr.or(right);
        return this;
    }

    public BooleanBuilder orAllOf(EBoolean ... args) {
        if (args.length > 0) {
            EBoolean all = args[0];
            for (int i = 1; i < args.length; ++i) {
                all = all.and(args[i]);
            }
            this.or(all);
        }
        return this;
    }

    @Override
    public BooleanBuilder not() {
        this.expr = this.expr.not();
        return this;
    }

    public boolean hasValue() {
        return this.expr != null;
    }

    public EBoolean getValue() {
        return this.expr;
    }

    @Override
    public void accept(Visitor v) {
        if (this.expr == null) {
            throw new RuntimeException("CascadingBoolean has no value");
        }
        this.expr.accept(v);
    }
}

