/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.path;

import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.EBoolean;
import com.mysema.query.types.expr.ENumber;
import com.mysema.query.types.operation.OBoolean;
import com.mysema.query.types.operation.Ops;
import com.mysema.query.types.path.Path;
import com.mysema.query.types.path.PathMetadata;
import com.mysema.query.util.NotEmpty;

public class PNumber<D extends Number>
extends ENumber<D>
implements Path<D> {
    private volatile EBoolean isnull;
    private volatile EBoolean isnotnull;
    private final PathMetadata<?> metadata;
    private final Path<?> root;

    public PNumber(Class<? extends D> type, PathMetadata<?> metadata) {
        super(type);
        this.metadata = metadata;
        this.root = metadata.getRoot() != null ? metadata.getRoot() : this;
    }

    public PNumber(Class<? extends D> type, @NotEmpty String var) {
        this(type, PathMetadata.forVariable(var));
    }

    public PNumber(Class<? extends D> type, Path<?> parent, @NotEmpty String property) {
        this(type, PathMetadata.forProperty(parent, property));
    }

    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }

    public boolean equals(Object o) {
        return o instanceof Path ? ((Path)o).getMetadata().equals(this.metadata) : false;
    }

    @Override
    public PathMetadata<?> getMetadata() {
        return this.metadata;
    }

    @Override
    public Path<?> getRoot() {
        return this.root;
    }

    @Override
    public int hashCode() {
        return this.metadata.hashCode();
    }

    @Override
    public EBoolean isNotNull() {
        if (this.isnotnull == null) {
            this.isnotnull = OBoolean.create(Ops.IS_NOT_NULL, this);
        }
        return this.isnotnull;
    }

    @Override
    public EBoolean isNull() {
        if (this.isnull == null) {
            this.isnull = OBoolean.create(Ops.IS_NULL, this);
        }
        return this.isnull;
    }

    @Override
    public ENumber<D> asExpr() {
        return this;
    }
}

