/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.path;

import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.EBoolean;
import com.mysema.query.types.expr.EMapBase;
import com.mysema.query.types.expr.Expr;
import com.mysema.query.types.operation.OBoolean;
import com.mysema.query.types.operation.Ops;
import com.mysema.query.types.path.PEntity;
import com.mysema.query.types.path.PMap;
import com.mysema.query.types.path.Path;
import com.mysema.query.types.path.PathMetadata;
import java.util.Map;

public class PEntityMap<K, V, E extends PEntity<V>>
extends EMapBase<K, V>
implements PMap<K, V> {
    private volatile EBoolean isnull;
    private volatile EBoolean isnotnull;
    private final Class<K> keyType;
    private final Class<V> valueType;
    private final Class<E> queryType;
    private final PathMetadata<?> metadata;
    private final Path<?> root;

    public PEntityMap(Class<? super K> keyType, Class<? super V> valueType, Class<E> queryType, PathMetadata<?> metadata) {
        super(Map.class);
        this.keyType = keyType;
        this.valueType = valueType;
        this.queryType = queryType;
        this.metadata = metadata;
        this.root = metadata.getRoot() != null ? metadata.getRoot() : this;
    }

    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }

    public boolean equals(Object o) {
        return o instanceof Path ? ((Path)o).getMetadata().equals(this.metadata) : false;
    }

    public E get(Expr<K> key) {
        PathMetadata<Expr<K>> md = PathMetadata.forMapAccess(this, key);
        try {
            return (E)((PEntity)this.queryType.getConstructor(PathMetadata.class).newInstance(md));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public E get(K key) {
        PathMetadata<K> md = PathMetadata.forMapAccess(this, key);
        try {
            return (E)((PEntity)this.queryType.getConstructor(PathMetadata.class).newInstance(md));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public Class<K> getKeyType() {
        return this.keyType;
    }

    @Override
    public PathMetadata<?> getMetadata() {
        return this.metadata;
    }

    @Override
    public Path<?> getRoot() {
        return this.root;
    }

    @Override
    public Class<V> getValueType() {
        return this.valueType;
    }

    @Override
    public int hashCode() {
        return this.metadata.hashCode();
    }

    @Override
    public EBoolean isNotNull() {
        if (this.isnotnull == null) {
            this.isnotnull = OBoolean.create(Ops.IS_NOT_NULL, this);
        }
        return this.isnotnull;
    }

    @Override
    public EBoolean isNull() {
        if (this.isnull == null) {
            this.isnull = OBoolean.create(Ops.IS_NULL, this);
        }
        return this.isnull;
    }

    public EMapBase<K, V> asExpr() {
        return this;
    }
}

