/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.path;

import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.EBoolean;
import com.mysema.query.types.expr.EEntity;
import com.mysema.query.types.expr.ExprConst;
import com.mysema.query.types.operation.OBoolean;
import com.mysema.query.types.operation.Ops;
import com.mysema.query.types.path.PBoolean;
import com.mysema.query.types.path.PComparable;
import com.mysema.query.types.path.PComponentCollection;
import com.mysema.query.types.path.PComponentList;
import com.mysema.query.types.path.PComponentMap;
import com.mysema.query.types.path.PDate;
import com.mysema.query.types.path.PDateTime;
import com.mysema.query.types.path.PEntityCollection;
import com.mysema.query.types.path.PEntityList;
import com.mysema.query.types.path.PEntityMap;
import com.mysema.query.types.path.PNumber;
import com.mysema.query.types.path.PSimple;
import com.mysema.query.types.path.PString;
import com.mysema.query.types.path.PTime;
import com.mysema.query.types.path.Path;
import com.mysema.query.types.path.PathMetadata;
import com.mysema.query.util.NotEmpty;
import java.util.HashMap;
import java.util.Map;

public class PEntity<D>
extends EEntity<D>
implements Path<D> {
    private final Map<Class<?>, Object> casts = new HashMap();
    private final String entityName;
    private volatile EBoolean isnull;
    private volatile EBoolean isnotnull;
    private final PathMetadata<?> metadata;
    private final Path<?> root;

    public PEntity(Class<? extends D> type, @NotEmpty String entityName, PathMetadata<?> metadata) {
        super(type);
        this.entityName = entityName;
        this.metadata = metadata;
        this.root = metadata.getRoot() != null ? metadata.getRoot() : this;
    }

    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }

    public <T extends PEntity<? extends D>> T as(Class<T> clazz) {
        try {
            if (!this.casts.containsKey(clazz)) {
                PEntity rv = (PEntity)clazz.getConstructor(PathMetadata.class).newInstance(this.getMetadata());
                this.casts.put(clazz, rv);
                return (T)rv;
            }
            return (T)((PEntity)this.casts.get(clazz));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public EEntity<D> asExpr() {
        return this;
    }

    protected PBoolean createBoolean(@NotEmpty String propertyName) {
        return new PBoolean(this, propertyName);
    }

    protected <A extends Comparable<?>> PComparable<A> createComparable(@NotEmpty String property, Class<A> type) {
        return new PComparable<A>(type, this, property);
    }

    protected <A extends Comparable<?>> PDate<A> createDate(@NotEmpty String property, Class<A> type) {
        return new PDate<A>(type, PathMetadata.forProperty(this, property));
    }

    protected <A extends Comparable<?>> PDateTime<A> createDateTime(@NotEmpty String property, Class<A> type) {
        return new PDateTime<A>(type, this, property);
    }

    protected <A> PEntityCollection<A> createEntityCollection(@NotEmpty String property, Class<? super A> type) {
        return new PEntityCollection<A>(type, type.getSimpleName(), this, property);
    }

    protected <A, E extends PEntity<A>> PEntityList<A, E> createEntityList(@NotEmpty String property, Class<? super A> type, Class<E> queryType) {
        return new PEntityList<A, E>(type, queryType, PathMetadata.forProperty(this, property));
    }

    protected <K, V, E extends PEntity<V>> PEntityMap<K, V, E> createEntityMap(@NotEmpty String property, Class<? super K> key, Class<? super V> value, Class<E> queryType) {
        return new PEntityMap<K, V, E>(key, value, queryType, PathMetadata.forProperty(this, property));
    }

    protected <A extends Number> PNumber<A> createNumber(@NotEmpty String property, Class<A> type) {
        return new PNumber<A>(type, this, property);
    }

    protected <A> PSimple<A> createSimple(@NotEmpty String path, Class<? super A> type) {
        return new PSimple<A>(type, this, path);
    }

    protected <A> PComponentCollection<A> createSimpleCollection(@NotEmpty String property, Class<? super A> type) {
        return new PComponentCollection<A>(type, this, property);
    }

    protected <A> PComponentList<A> createSimpleList(@NotEmpty String property, Class<? super A> type) {
        return new PComponentList<A>(type, PathMetadata.forProperty(this, property));
    }

    protected <K, V> PComponentMap<K, V> createSimpleMap(@NotEmpty String property, Class<? super K> key, Class<? super V> value) {
        return new PComponentMap<K, V>(key, value, this, property);
    }

    protected PString createString(@NotEmpty String property) {
        return new PString(this, property);
    }

    protected <A extends Comparable<?>> PTime<A> createTime(@NotEmpty String property, Class<A> type) {
        return new PTime<A>(type, this, property);
    }

    public boolean equals(Object o) {
        return o instanceof Path ? ((Path)o).getMetadata().equals(this.metadata) : false;
    }

    public String getEntityName() {
        return this.entityName;
    }

    @Override
    public PathMetadata<?> getMetadata() {
        return this.metadata;
    }

    @Override
    public Path<?> getRoot() {
        return this.root;
    }

    @Override
    public int hashCode() {
        return this.metadata.hashCode();
    }

    public <B extends D> EBoolean instanceOf(Class<B> type) {
        return OBoolean.create(Ops.INSTANCE_OF, this, ExprConst.create(type));
    }

    @Override
    public EBoolean isNotNull() {
        if (this.isnotnull == null) {
            this.isnotnull = OBoolean.create(Ops.IS_NOT_NULL, this);
        }
        return this.isnotnull;
    }

    @Override
    public EBoolean isNull() {
        if (this.isnull == null) {
            this.isnull = OBoolean.create(Ops.IS_NULL, this);
        }
        return this.isnull;
    }
}

