/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.path;

import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.EBoolean;
import com.mysema.query.types.expr.ECollectionBase;
import com.mysema.query.types.expr.Expr;
import com.mysema.query.types.operation.OBoolean;
import com.mysema.query.types.operation.Ops;
import com.mysema.query.types.path.PCollection;
import com.mysema.query.types.path.Path;
import com.mysema.query.types.path.PathMetadata;
import com.mysema.query.util.NotEmpty;
import java.util.Collection;

public class PComponentCollection<D>
extends ECollectionBase<D>
implements PCollection<D> {
    protected final Class<D> type;
    private final Path<?> root;
    private final PathMetadata<?> metadata;
    private volatile EBoolean isnull;
    private volatile EBoolean isnotnull;

    public PComponentCollection(Class<? super D> type, PathMetadata<?> metadata) {
        super(Collection.class);
        this.type = type;
        this.metadata = metadata;
        this.root = metadata.getRoot() != null ? metadata.getRoot() : this;
    }

    public PComponentCollection(Class<? super D> type, @NotEmpty String var) {
        this(type, PathMetadata.forVariable(var));
    }

    public PComponentCollection(Class<? super D> type, Path<?> parent, @NotEmpty String property) {
        this(type, PathMetadata.forProperty(parent, property));
    }

    public boolean equals(Object o) {
        return o instanceof Path ? ((Path)o).getMetadata().equals(this.metadata) : false;
    }

    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }

    @Override
    public Class<D> getElementType() {
        return this.type;
    }

    @Override
    public PathMetadata<?> getMetadata() {
        return this.metadata;
    }

    @Override
    public Path<?> getRoot() {
        return this.root;
    }

    @Override
    public int hashCode() {
        return this.metadata.hashCode();
    }

    @Override
    public EBoolean isNotNull() {
        if (this.isnotnull == null) {
            this.isnotnull = OBoolean.create(Ops.IS_NOT_NULL, this);
        }
        return this.isnotnull;
    }

    @Override
    public EBoolean isNull() {
        if (this.isnull == null) {
            this.isnull = OBoolean.create(Ops.IS_NULL, this);
        }
        return this.isnull;
    }

    @Override
    public Expr<Collection<D>> asExpr() {
        return this;
    }
}

