/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.Constant;
import com.mysema.query.types.expr.EBoolean;
import com.mysema.query.types.expr.ENumber;
import com.mysema.query.types.expr.Expr;
import com.mysema.util.MathUtils;

public class ENumberConst<D extends Number>
extends ENumber<D>
implements Constant<D> {
    private final D constant;

    ENumberConst(Class<? extends D> type, D constant) {
        super(type);
        this.constant = constant;
    }

    @Override
    public EBoolean eq(D b) {
        return EBoolean.create(this.constant.equals(b));
    }

    public boolean equals(Object o) {
        return o instanceof Constant ? ((Constant)o).getConstant().equals(this.constant) : false;
    }

    @Override
    public D getConstant() {
        return this.constant;
    }

    @Override
    public int hashCode() {
        return this.constant.hashCode();
    }

    @Override
    public EBoolean ne(D b) {
        return EBoolean.create(!this.constant.equals(b));
    }

    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }

    @Override
    public ENumber<D> add(Number right) {
        return ENumber.create(MathUtils.sum(this.constant, right));
    }

    @Override
    public <N extends Number> ENumber<D> add(Expr<N> right) {
        if (right instanceof Constant) {
            return this.add((Number)((Constant)((Object)right)).getConstant());
        }
        return super.add(right);
    }

    @Override
    public ENumber<D> subtract(Number right) {
        return ENumber.create(MathUtils.difference(this.constant, right));
    }

    @Override
    public <N extends Number> ENumber<D> subtract(Expr<N> right) {
        if (right instanceof Constant) {
            return this.subtract((Number)((Constant)((Object)right)).getConstant());
        }
        return super.subtract(right);
    }

    @Override
    public ENumber<Byte> byteValue() {
        return ENumber.create(((Number)this.constant).byteValue());
    }

    @Override
    public ENumber<Double> doubleValue() {
        return ENumber.create(((Number)this.constant).doubleValue());
    }

    @Override
    public ENumber<Float> floatValue() {
        return ENumber.create(Float.valueOf(((Number)this.constant).floatValue()));
    }

    @Override
    public ENumber<Long> longValue() {
        return ENumber.create(((Number)this.constant).longValue());
    }

    @Override
    public ENumber<Short> shortValue() {
        return ENumber.create(((Number)this.constant).shortValue());
    }
}

