/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.Constant;
import com.mysema.query.types.expr.EDateTime;
import com.mysema.query.types.expr.ENumber;
import java.util.Calendar;
import java.util.Date;

public class EDateTimeConst
extends EDateTime<Date>
implements Constant<Date> {
    private final Calendar calendar = Calendar.getInstance();
    private final Date date;

    public EDateTimeConst(Date date) {
        super(Date.class);
        this.date = date;
        this.calendar.setTime(date);
    }

    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }

    @Override
    public ENumber<Integer> getDayOfMonth() {
        return ENumber.create(this.calendar.get(5));
    }

    @Override
    public ENumber<Integer> getMonth() {
        return ENumber.create(this.calendar.get(2) + 1);
    }

    @Override
    public ENumber<Integer> getYear() {
        return ENumber.create(this.calendar.get(1));
    }

    @Override
    public ENumber<Integer> getDayOfWeek() {
        return ENumber.create(this.calendar.get(7));
    }

    @Override
    public ENumber<Integer> getDayOfYear() {
        return ENumber.create(this.calendar.get(6));
    }

    @Override
    public ENumber<Integer> getWeek() {
        return ENumber.create(this.calendar.get(3));
    }

    @Override
    public ENumber<Integer> getHour() {
        return ENumber.create(this.calendar.get(11));
    }

    @Override
    public ENumber<Integer> getMinute() {
        return ENumber.create(this.calendar.get(12));
    }

    @Override
    public ENumber<Integer> getSecond() {
        return ENumber.create(this.calendar.get(13));
    }

    @Override
    public ENumber<Integer> getMilliSecond() {
        return ENumber.create(this.calendar.get(14));
    }

    @Override
    public Date getConstant() {
        return this.date;
    }
}

