/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.query.types.expr.EDateOrTime;
import com.mysema.query.types.expr.EDateTimeConst;
import com.mysema.query.types.expr.ENumber;
import com.mysema.query.types.expr.Expr;
import com.mysema.query.types.operation.ODateTime;
import com.mysema.query.types.operation.ONumber;
import com.mysema.query.types.operation.Ops;
import java.util.Date;

public abstract class EDateTime<D extends Comparable>
extends EDateOrTime<D> {
    private static final EDateTime<Date> currentDate = EDateTime.currentDate(Date.class);
    private static final EDateTime<Date> currentTimestamp = EDateTime.currentTimestamp(Date.class);
    private volatile ENumber<Integer> dayOfMonth;
    private volatile ENumber<Integer> dayOfWeek;
    private volatile ENumber<Integer> dayOfYear;
    private volatile ENumber<Integer> year;
    private volatile ENumber<Integer> month;
    private volatile ENumber<Integer> week;
    private volatile ENumber<Integer> hours;
    private volatile ENumber<Integer> minutes;
    private volatile ENumber<Integer> seconds;
    private volatile ENumber<Integer> milliseconds;

    public static EDateTime<Date> create(Date date) {
        return new EDateTimeConst(date);
    }

    public static EDateTime<Date> currentDate() {
        return currentDate;
    }

    public static <T extends Comparable> EDateTime<T> currentDate(Class<T> cl) {
        return ODateTime.create(cl, Ops.DateTimeOps.CURRENT_DATE, new Expr[0]);
    }

    public static EDateTime<Date> currentTimestamp() {
        return currentTimestamp;
    }

    public static <T extends Comparable> EDateTime<T> currentTimestamp(Class<T> cl) {
        return ODateTime.create(cl, Ops.DateTimeOps.CURRENT_TIMESTAMP, new Expr[0]);
    }

    public EDateTime(Class<? extends D> type) {
        super(type);
    }

    public ENumber<Integer> getDayOfMonth() {
        if (this.dayOfMonth == null) {
            this.dayOfMonth = ONumber.create(Integer.class, Ops.DateTimeOps.DAY_OF_MONTH, this);
        }
        return this.dayOfMonth;
    }

    public ENumber<Integer> getDayOfWeek() {
        if (this.dayOfWeek == null) {
            this.dayOfWeek = ONumber.create(Integer.class, Ops.DateTimeOps.DAY_OF_WEEK, this);
        }
        return this.dayOfWeek;
    }

    public ENumber<Integer> getDayOfYear() {
        if (this.dayOfYear == null) {
            this.dayOfYear = ONumber.create(Integer.class, Ops.DateTimeOps.DAY_OF_YEAR, this);
        }
        return this.dayOfYear;
    }

    public ENumber<Integer> getHour() {
        if (this.hours == null) {
            this.hours = ONumber.create(Integer.class, Ops.DateTimeOps.HOUR, this);
        }
        return this.hours;
    }

    public ENumber<Integer> getMilliSecond() {
        if (this.milliseconds == null) {
            this.milliseconds = ONumber.create(Integer.class, Ops.DateTimeOps.MILLISECOND, this);
        }
        return this.milliseconds;
    }

    public ENumber<Integer> getMinute() {
        if (this.minutes == null) {
            this.minutes = ONumber.create(Integer.class, Ops.DateTimeOps.MINUTE, this);
        }
        return this.minutes;
    }

    public ENumber<Integer> getMonth() {
        if (this.month == null) {
            this.month = ONumber.create(Integer.class, Ops.DateTimeOps.MONTH, this);
        }
        return this.month;
    }

    public ENumber<Integer> getSecond() {
        if (this.seconds == null) {
            this.seconds = ONumber.create(Integer.class, Ops.DateTimeOps.SECOND, this);
        }
        return this.seconds;
    }

    public ENumber<Integer> getWeek() {
        if (this.week == null) {
            this.week = ONumber.create(Integer.class, Ops.DateTimeOps.WEEK, this);
        }
        return this.week;
    }

    public ENumber<Integer> getYear() {
        if (this.year == null) {
            this.year = ONumber.create(Integer.class, Ops.DateTimeOps.YEAR, this);
        }
        return this.year;
    }
}

