/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.Constant;
import com.mysema.query.types.expr.EDate;
import com.mysema.query.types.expr.ENumber;
import java.sql.Date;
import java.util.Calendar;

public class EDateConst
extends EDate<Date>
implements Constant<Date> {
    private final Date date;
    private final Calendar calendar;

    public EDateConst(Date date) {
        super(Date.class);
        this.date = date;
        this.calendar = Calendar.getInstance();
        this.calendar.setTime(date);
    }

    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }

    @Override
    public ENumber<Integer> getDayOfMonth() {
        return ENumber.create(this.calendar.get(5));
    }

    @Override
    public ENumber<Integer> getMonth() {
        return ENumber.create(this.calendar.get(2) + 1);
    }

    @Override
    public ENumber<Integer> getYear() {
        return ENumber.create(this.calendar.get(1));
    }

    @Override
    public ENumber<Integer> getDayOfWeek() {
        return ENumber.create(this.calendar.get(7));
    }

    @Override
    public ENumber<Integer> getDayOfYear() {
        return ENumber.create(this.calendar.get(6));
    }

    @Override
    public ENumber<Integer> getWeek() {
        return ENumber.create(this.calendar.get(3));
    }

    @Override
    public Date getConstant() {
        return this.date;
    }
}

