/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.query.types.expr.EDateConst;
import com.mysema.query.types.expr.EDateOrTime;
import com.mysema.query.types.expr.ENumber;
import com.mysema.query.types.expr.Expr;
import com.mysema.query.types.operation.ODate;
import com.mysema.query.types.operation.ONumber;
import com.mysema.query.types.operation.Ops;
import java.util.Date;

public abstract class EDate<D extends Comparable>
extends EDateOrTime<D> {
    private static final EDate<Date> currentDate = EDate.currentDate(Date.class);
    private volatile ENumber<Integer> dayOfMonth;
    private volatile ENumber<Integer> dayOfWeek;
    private volatile ENumber<Integer> dayOfYear;
    private volatile ENumber<Integer> week;
    private volatile ENumber<Integer> month;
    private volatile ENumber<Integer> year;

    public static EDate<java.sql.Date> create(java.sql.Date date) {
        return new EDateConst(date);
    }

    public static EDate<Date> currentDate() {
        return currentDate;
    }

    public static <T extends Comparable> EDate<T> currentDate(Class<T> cl) {
        return ODate.create(cl, Ops.DateTimeOps.CURRENT_DATE, new Expr[0]);
    }

    public EDate(Class<? extends D> type) {
        super(type);
    }

    public ENumber<Integer> getDayOfMonth() {
        if (this.dayOfMonth == null) {
            this.dayOfMonth = ONumber.create(Integer.class, Ops.DateTimeOps.DAY_OF_MONTH, this);
        }
        return this.dayOfMonth;
    }

    public ENumber<Integer> getDayOfWeek() {
        if (this.dayOfWeek == null) {
            this.dayOfWeek = ONumber.create(Integer.class, Ops.DateTimeOps.DAY_OF_WEEK, this);
        }
        return this.dayOfWeek;
    }

    public ENumber<Integer> getDayOfYear() {
        if (this.dayOfYear == null) {
            this.dayOfYear = ONumber.create(Integer.class, Ops.DateTimeOps.DAY_OF_YEAR, this);
        }
        return this.dayOfYear;
    }

    public ENumber<Integer> getMonth() {
        if (this.month == null) {
            this.month = ONumber.create(Integer.class, Ops.DateTimeOps.MONTH, this);
        }
        return this.month;
    }

    public ENumber<Integer> getWeek() {
        if (this.week == null) {
            this.week = ONumber.create(Integer.class, Ops.DateTimeOps.WEEK, this);
        }
        return this.week;
    }

    public ENumber<Integer> getYear() {
        if (this.year == null) {
            this.year = ONumber.create(Integer.class, Ops.DateTimeOps.YEAR, this);
        }
        return this.year;
    }
}

