/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.query.types.Order;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.expr.EBoolean;
import com.mysema.query.types.expr.ENumber;
import com.mysema.query.types.expr.EString;
import com.mysema.query.types.expr.Expr;
import com.mysema.query.types.expr.ExprConst;
import com.mysema.query.types.operation.OBoolean;
import com.mysema.query.types.operation.ONumber;
import com.mysema.query.types.operation.OString;
import com.mysema.query.types.operation.Ops;

public abstract class EComparableBase<D extends Comparable>
extends Expr<D> {
    private volatile OrderSpecifier<D> asc;
    private volatile OrderSpecifier<D> desc;
    private volatile EString stringCast;

    public EComparableBase(Class<? extends D> type) {
        super(type);
    }

    public final OrderSpecifier<D> asc() {
        if (this.asc == null) {
            this.asc = new OrderSpecifier(Order.ASC, this);
        }
        return this.asc;
    }

    public final EBoolean between(D first, D second) {
        return OBoolean.create(Ops.BETWEEN, this, ExprConst.create(first), ExprConst.create(second));
    }

    public final EBoolean between(Expr<D> first, Expr<D> second) {
        return OBoolean.create(Ops.BETWEEN, this, first, second);
    }

    public <A extends Number> ENumber<A> castToNum(Class<A> type) {
        return ONumber.create(type, Ops.NUMCAST, this, ExprConst.create(type));
    }

    public final OrderSpecifier<D> desc() {
        if (this.desc == null) {
            this.desc = new OrderSpecifier(Order.DESC, this);
        }
        return this.desc;
    }

    public final EBoolean notBetween(D first, D second) {
        return this.between(first, second).not();
    }

    public final EBoolean notBetween(Expr<D> first, Expr<D> second) {
        return this.between(first, second).not();
    }

    public EString stringValue() {
        if (this.stringCast == null) {
            this.stringCast = OString.create(Ops.STRING_CAST, this);
        }
        return this.stringCast;
    }
}

