/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types;

import com.mysema.query.types.TemplateFactory;
import com.mysema.query.types.custom.CSimple;
import com.mysema.query.types.expr.EBoolean;
import com.mysema.query.types.expr.Expr;
import com.mysema.query.types.operation.OSimple;
import com.mysema.query.types.operation.Ops;
import java.util.ArrayList;
import java.util.List;

public class CaseBuilder {
    private static final TemplateFactory templateFactory = new TemplateFactory();

    public Initial when(EBoolean b) {
        return new Initial(b);
    }

    public class Initial {
        private final EBoolean b;

        public Initial(EBoolean b) {
            this.b = b;
        }

        public <A> Cases<A> then(A constant) {
            return new Cases(constant.getClass()).addCase(this.b, Expr.create(constant));
        }

        public <A> Cases<A> then(Expr<A> expr) {
            return new Cases<A>(expr.getType()).addCase(this.b, expr);
        }
    }

    public class CaseWhen<A> {
        private final EBoolean b;
        private final Cases<A> cases;

        public CaseWhen(Cases<A> cases, EBoolean b) {
            this.cases = cases;
            this.b = b;
        }

        public Cases<A> then(A constant) {
            return this.cases.addCase(this.b, Expr.create(constant));
        }

        public Cases<A> then(Expr<A> expr) {
            return this.cases.addCase(this.b, expr);
        }
    }

    public class Cases<A> {
        private final List<Expr<?>> exprs = new ArrayList();
        private final Class<A> type;

        public Cases(Class<A> type) {
            this.type = type;
        }

        Cases<A> addCase(EBoolean condition, Expr<A> expr) {
            this.exprs.add(OSimple.create(this.type, Ops.CASE_WHEN, condition, expr));
            return this;
        }

        private Expr<A> createChain(List<Expr<?>> exprs) {
            StringBuilder builder = new StringBuilder(exprs.size() * 4);
            for (int i = 0; i < exprs.size(); ++i) {
                if (i > 0) {
                    builder.append(" ");
                }
                builder.append("{").append(i).append("}");
            }
            return new CSimple<A>(this.type, exprs, templateFactory.create(builder.toString()));
        }

        public Expr<A> otherwise(A constant) {
            return this.otherwise(Expr.create(constant));
        }

        public Expr<A> otherwise(Expr<A> expr) {
            this.exprs.add(OSimple.create(this.type, Ops.CASE_ELSE, expr));
            return OSimple.create(this.type, Ops.CASE, this.createChain(this.exprs));
        }

        public CaseWhen<A> when(EBoolean b) {
            return new CaseWhen(this, b);
        }
    }
}

