/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.codegen;

import com.mysema.commons.lang.Assert;
import com.mysema.query.codegen.BeanModel;
import com.mysema.query.codegen.TypeCategory;
import com.mysema.query.codegen.TypeModel;
import net.jcip.annotations.Immutable;

@Immutable
public final class SimpleTypeModel
implements TypeModel {
    private final String fullName;
    private final String packageName;
    private final String simpleName;
    private final String localName;
    private final TypeModel[] parameters;
    private final TypeCategory typeCategory;
    private final boolean visible;
    private final boolean finalClass;

    public SimpleTypeModel(TypeCategory typeCategory, String name, String packageName, String simpleName, boolean finalClass, TypeModel ... parameters) {
        this.typeCategory = (TypeCategory)((Object)Assert.notNull((Object)((Object)typeCategory), (String)"typeCategory is null"));
        this.fullName = (String)Assert.notNull((Object)name, (String)"name is null");
        this.packageName = (String)Assert.notNull((Object)packageName, (String)"packageName is null");
        this.simpleName = (String)Assert.notNull((Object)simpleName, (String)"simpleName is null");
        this.localName = name.substring(packageName.length() + 1);
        this.parameters = (TypeModel[])Assert.notNull((Object)parameters);
        this.visible = packageName.equals("java.lang");
        this.finalClass = finalClass;
    }

    @Override
    public SimpleTypeModel as(TypeCategory category) {
        if (this.typeCategory == category) {
            return this;
        }
        return new SimpleTypeModel(category, this.fullName, this.packageName, this.simpleName, this.finalClass, this.parameters);
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public String getLocalGenericName(BeanModel context) {
        if (this.parameters.length > 0) {
            StringBuilder builder = new StringBuilder();
            if (!this.visible && !context.getPackageName().equals(this.packageName)) {
                builder.append(this.packageName).append(".");
            }
            builder.append(this.localName).append("<");
            for (int i = 0; i < this.parameters.length; ++i) {
                if (i > 0) {
                    builder.append(",");
                }
                if (this.parameters[i] != null && !this.parameters[i].equals(this)) {
                    builder.append(this.parameters[i].getLocalGenericName(context));
                    continue;
                }
                builder.append("?");
            }
            builder.append(">");
            return builder.toString();
        }
        return this.getLocalRawName(context);
    }

    @Override
    public String getLocalRawName(BeanModel context) {
        if (this.visible || context.getPackageName().equals(this.packageName)) {
            return this.localName;
        }
        return this.fullName;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public TypeModel getParameter(int i) {
        return this.parameters[i];
    }

    @Override
    public int getParameterCount() {
        return this.parameters.length;
    }

    @Override
    public String getPrimitiveName() {
        return null;
    }

    @Override
    public TypeModel getSelfOrValueType() {
        if (this.typeCategory.isSubCategoryOf(TypeCategory.COLLECTION) || this.typeCategory.isSubCategoryOf(TypeCategory.MAP)) {
            return this.parameters[this.parameters.length - 1];
        }
        return this;
    }

    @Override
    public String getSimpleName() {
        return this.simpleName;
    }

    @Override
    public TypeCategory getTypeCategory() {
        return this.typeCategory;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public String toString() {
        return this.fullName;
    }

    public boolean equals(Object o) {
        if (o instanceof TypeModel) {
            TypeModel t = (TypeModel)o;
            return this.fullName.equals(t.getFullName());
        }
        return false;
    }

    public int hashCode() {
        return this.fullName.hashCode();
    }

    @Override
    public boolean isFinal() {
        return this.finalClass;
    }
}

