/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.codegen;

import com.mysema.commons.lang.Assert;
import com.mysema.query.codegen.BeanModel;
import com.mysema.query.codegen.TypeCategory;
import com.mysema.query.codegen.TypeModel;
import com.mysema.util.JavaSyntaxUtils;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.jcip.annotations.Immutable;

@Immutable
public final class PropertyModel
implements Comparable<PropertyModel> {
    private final BeanModel context;
    private final boolean inherited;
    private final String name;
    private final String escapedName;
    private final String typeName;
    @Nullable
    private final String queryTypeName;
    private final TypeModel type;
    private final String[] inits;

    public PropertyModel(BeanModel classModel, String name, TypeModel type, String[] inits) {
        this(classModel, name, type, inits, false);
    }

    public PropertyModel(BeanModel classModel, String name, TypeModel type, String[] inits, boolean inherited) {
        TypeModel valueType;
        this.context = classModel;
        this.name = (String)Assert.notNull((Object)name);
        this.escapedName = JavaSyntaxUtils.isReserved(name) ? name + "_" : name;
        this.type = (TypeModel)Assert.notNull((Object)type);
        this.typeName = type.getLocalRawName(classModel);
        this.queryTypeName = type.getTypeCategory().isSubCategoryOf(TypeCategory.SIMPLE) ? null : ((valueType = type.getSelfOrValueType()).getPackageName().equals(classModel.getPackageName()) ? classModel.getPrefix() + valueType.getSimpleName() : valueType.getPackageName() + "." + classModel.getPrefix() + valueType.getSimpleName());
        this.inits = inits;
        this.inherited = inherited;
    }

    @Override
    public int compareTo(PropertyModel o) {
        return this.name.compareToIgnoreCase(o.getName());
    }

    public PropertyModel createCopy(BeanModel model) {
        boolean inherited = model.getSuperModel() != null;
        return new PropertyModel(model, this.name, this.type, this.inits, inherited);
    }

    public boolean equals(Object o) {
        return o instanceof PropertyModel && this.name.equals(((PropertyModel)o).name);
    }

    public String getEscapedName() {
        return this.escapedName;
    }

    @Nullable
    public String getGenericParameterName(int i) {
        if (i < this.type.getParameterCount()) {
            return this.type.getParameter(i).getLocalGenericName(this.context);
        }
        return null;
    }

    public String getGenericTypeName() {
        return this.type.getLocalGenericName(this.context);
    }

    public String[] getInits() {
        return this.inits;
    }

    public BeanModel getBeanModel() {
        return this.context;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getRawParameterName(int i) {
        if (i < this.type.getParameterCount()) {
            return this.type.getParameter(i).getLocalRawName(this.context);
        }
        return null;
    }

    public String getQueryTypeName() {
        return this.queryTypeName;
    }

    public String getSimpleTypeName() {
        return this.type.getSimpleName();
    }

    public TypeCategory getTypeCategory() {
        return this.type.getTypeCategory();
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getTypePackage() {
        return this.type.getPackageName();
    }

    public int hashCode() {
        return ((Object)Arrays.asList(this.name, this.type)).hashCode();
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public String toString() {
        return this.type.getFullName() + " " + this.name;
    }
}

