/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.codegen;

import com.mysema.query.codegen.BeanModel;
import com.mysema.query.codegen.ConstructorModel;
import com.mysema.query.codegen.ParameterModel;
import com.mysema.query.codegen.PropertyModel;
import com.mysema.query.codegen.Serializer;
import com.mysema.query.codegen.TypeCategory;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import net.jcip.annotations.Immutable;

@Immutable
public class EntitySerializer
implements Serializer {
    protected void booleanField(PropertyModel field, Writer writer) throws IOException {
        this.serialize(field, "PBoolean", writer, "createBoolean", new String[0]);
    }

    protected void collectionOfEntity(PropertyModel field, Writer writer) throws IOException {
        String genericTypeName = field.getGenericParameterName(0);
        String typeName = field.getRawParameterName(0);
        this.serialize(field, "PEntityCollection<" + genericTypeName + ">", writer, "createEntityCollection", typeName + ".class");
    }

    protected void collectionOfSimple(PropertyModel field, Writer writer) throws IOException {
        String genericTypeName = field.getGenericParameterName(0);
        String typeName = field.getRawParameterName(0);
        this.serialize(field, "PComponentCollection<" + genericTypeName + ">", writer, "createSimpleCollection", typeName + ".class");
    }

    protected void comparableField(PropertyModel field, Writer writer) throws IOException {
        this.serialize(field, "PComparable<" + field.getGenericTypeName() + ">", writer, "createComparable", field.getTypeName() + ".class");
    }

    protected void constructors(BeanModel model, Writer writer) throws IOException {
        String simpleName = model.getSimpleName();
        String queryType = model.getPrefix() + simpleName;
        String localName = model.getLocalName();
        String genericName = model.getGenericName();
        StringBuilder builder = new StringBuilder();
        boolean hasEntityFields = model.hasEntityFields();
        String thisOrSuper = hasEntityFields ? "this" : "super";
        this.constructorsForVariables(builder, model);
        if (!hasEntityFields) {
            builder.append("    public " + queryType + "(PEntity<? extends " + genericName + "> entity) {\n");
            builder.append("        super(entity.getType(), entity.getEntityName(), entity.getMetadata()");
            builder.append(");\n");
            builder.append("    }\n\n");
        }
        if (hasEntityFields) {
            builder.append("    public " + queryType + "(PathMetadata<?> metadata) {\n");
            builder.append("        this(metadata, metadata.isRoot() ? INITS : PathInits.DEFAULT);\n");
            builder.append("    }\n\n");
        } else {
            if (!localName.equals(genericName)) {
                builder.append("    @SuppressWarnings(\"unchecked\")\n");
            }
            builder.append("    public " + queryType + "(PathMetadata<?> metadata) {\n");
            builder.append("        super(");
            if (!localName.equals(genericName)) {
                builder.append("(Class)");
            }
            builder.append(localName + ".class, \"" + simpleName + "\", metadata);\n");
            builder.append("    }\n\n");
        }
        if (!localName.equals(genericName)) {
            builder.append("    @SuppressWarnings(\"unchecked\")\n");
        }
        builder.append("    public " + queryType + "(PathMetadata<?> metadata, PathInits inits) {\n");
        builder.append("        " + thisOrSuper + "(");
        if (!localName.equals(genericName)) {
            builder.append("(Class)");
        }
        builder.append(localName + ".class, \"" + simpleName + "\", metadata");
        if (hasEntityFields) {
            builder.append(", inits");
        }
        builder.append(");\n");
        builder.append("    }\n\n");
        if (hasEntityFields) {
            builder.append("    public " + queryType + "(Class<? extends " + genericName + "> type, @NotEmpty String entityName, PathMetadata<?> metadata, PathInits inits) {\n");
            builder.append("        super(type, entityName, metadata);\n");
            this.initEntityFields(builder, model);
            builder.append("    }\n\n");
        }
        writer.append(builder.toString());
    }

    protected void constructorsForVariables(StringBuilder builder, BeanModel model) {
        String thisOrSuper;
        String simpleName = model.getSimpleName();
        String queryType = model.getPrefix() + simpleName;
        String localName = model.getLocalName();
        String genericName = model.getGenericName();
        boolean hasEntityFields = model.hasEntityFields();
        String string = thisOrSuper = hasEntityFields ? "this" : "super";
        if (!localName.equals(genericName)) {
            builder.append("    @SuppressWarnings(\"unchecked\")\n");
        }
        builder.append("    public " + queryType + "(@NotEmpty String variable) {\n");
        builder.append("        " + thisOrSuper + "(");
        if (!localName.equals(genericName)) {
            builder.append("(Class)");
        }
        builder.append(localName + ".class, \"" + simpleName + "\", PathMetadata.forVariable(variable)");
        if (hasEntityFields) {
            builder.append(", INITS");
        }
        builder.append(");\n");
        builder.append("    }\n\n");
    }

    protected void dateField(PropertyModel field, Writer writer) throws IOException {
        this.serialize(field, "PDate<" + field.getGenericTypeName() + ">", writer, "createDate", field.getTypeName() + ".class");
    }

    protected void dateTimeField(PropertyModel field, Writer writer) throws IOException {
        this.serialize(field, "PDateTime<" + field.getGenericTypeName() + ">", writer, "createDateTime", field.getTypeName() + ".class");
    }

    protected void entityField(PropertyModel field, Writer writer) throws IOException {
        String type = field.getQueryTypeName();
        StringBuilder builder = new StringBuilder();
        if (field.isInherited()) {
            builder.append("    // inherited\n");
        }
        builder.append("    public final " + type + " " + field.getEscapedName() + ";\n\n");
        writer.append(builder.toString());
    }

    protected void initEntityFields(StringBuilder builder, BeanModel model) {
        BeanModel superModel = model.getSuperModel();
        if (superModel != null && superModel.hasEntityFields()) {
            String superQueryType = superModel.getPrefix() + superModel.getSimpleName();
            if (!superModel.getPackageName().equals(model.getPackageName())) {
                superQueryType = superModel.getPackageName() + "." + superQueryType;
            }
            builder.append("        this._super = new " + superQueryType + "(type, entityName, metadata, inits);\n");
        }
        for (PropertyModel field : model.getProperties()) {
            if (field.getTypeCategory() == TypeCategory.ENTITY) {
                builder.append("        this." + field.getEscapedName() + " = ");
                if (!field.isInherited()) {
                    builder.append("inits.isInitialized(\"" + field.getName() + "\") ? ");
                    builder.append("new " + field.getQueryTypeName() + "(PathMetadata.forProperty(this,\"" + field.getName() + "\"), inits.getInits(\"" + field.getName() + "\")) : null;\n");
                    continue;
                }
                builder.append("_super." + field.getEscapedName() + ";\n");
                continue;
            }
            if (!field.isInherited() || superModel == null || !superModel.hasEntityFields()) continue;
            builder.append("        this." + field.getEscapedName() + " = ");
            builder.append("_super." + field.getEscapedName() + ";\n");
        }
    }

    protected void intro(BeanModel model, Writer writer) throws IOException {
        StringBuilder builder = new StringBuilder();
        this.introPackage(builder, model);
        this.introImports(builder, model);
        this.introJavadoc(builder, model);
        this.introClassHeader(builder, model);
        this.introFactoryMethods(builder, model);
        this.introInits(builder, model);
        this.introDefaultInstance(builder, model);
        if (model.getSuperModel() != null) {
            this.introSuper(builder, model);
        }
        writer.append(builder.toString());
    }

    protected void introClassHeader(StringBuilder builder, BeanModel model) {
        String queryType = model.getPrefix() + model.getSimpleName();
        String localName = model.getGenericName();
        builder.append("@SuppressWarnings(\"serial\")\n");
        builder.append("public class " + queryType + " extends PEntity<" + localName + "> {\n\n");
    }

    protected void introDefaultInstance(StringBuilder builder, BeanModel model) {
        String simpleName = model.getSimpleName();
        String unscapSimpleName = model.getUncapSimpleName();
        String queryType = model.getPrefix() + simpleName;
        builder.append("    public static final " + queryType + " " + unscapSimpleName + " = new " + queryType + "(\"" + unscapSimpleName + "\");\n\n");
    }

    protected void introFactoryMethods(StringBuilder builder, BeanModel model) throws IOException {
        String localName = model.getLocalName();
        String genericName = model.getGenericName();
        for (ConstructorModel c : model.getConstructors()) {
            if (!localName.equals(genericName)) {
                builder.append("    @SuppressWarnings(\"unchecked\")\n");
            }
            builder.append("    public static EConstructor<" + genericName + "> project(");
            boolean first = true;
            for (ParameterModel p : c.getParameters()) {
                if (!first) {
                    builder.append(", ");
                }
                builder.append("Expr<");
                if (!p.getType().isFinal()) {
                    builder.append("? extends ");
                }
                builder.append(p.getType().getLocalGenericName(model) + "> " + p.getName());
                first = false;
            }
            builder.append("){\n");
            builder.append("        return new EConstructor<" + genericName + ">(");
            if (!localName.equals(genericName)) {
                builder.append("(Class)");
            }
            builder.append(localName + ".class");
            builder.append(", new Class[]{");
            first = true;
            for (ParameterModel p : c.getParameters()) {
                if (!first) {
                    builder.append(", ");
                }
                if (p.getType().getPrimitiveName() != null) {
                    builder.append(p.getType().getPrimitiveName() + ".class");
                } else {
                    builder.append(p.getType().getLocalRawName(model) + ".class");
                }
                first = false;
            }
            builder.append("}");
            for (ParameterModel p : c.getParameters()) {
                builder.append(", " + p.getName());
            }
            builder.append(");\n");
            builder.append("    }\n\n");
        }
    }

    protected void introImports(StringBuilder builder, BeanModel model) {
        builder.append("import com.mysema.query.util.*;\n");
        builder.append("import com.mysema.query.types.path.*;\n");
        if (!model.getConstructors().isEmpty() || model.hasLists() || model.hasMaps()) {
            builder.append("import com.mysema.query.types.expr.*;\n");
        }
    }

    protected void introInits(StringBuilder builder, BeanModel model) {
        if (model.hasEntityFields()) {
            ArrayList<String> inits = new ArrayList<String>();
            for (PropertyModel property : model.getProperties()) {
                if (property.getTypeCategory() != TypeCategory.ENTITY) continue;
                for (String init : property.getInits()) {
                    inits.add(property.getEscapedName() + "." + init);
                }
            }
            if (!inits.isEmpty()) {
                builder.append("    private static final PathInits INITS = new PathInits(\"*\"");
                for (String init : inits) {
                    builder.append(", \"" + init + "\"");
                }
                builder.append(");\n\n");
            } else {
                builder.append("    private static final PathInits INITS = PathInits.DIRECT;\n\n");
            }
        }
    }

    protected void introJavadoc(StringBuilder builder, BeanModel model) {
        String simpleName = model.getSimpleName();
        String queryType = model.getPrefix() + simpleName;
        builder.append("/**\n");
        builder.append(" * " + queryType + " is a Querydsl query type for " + simpleName + "\n");
        builder.append(" * \n");
        builder.append(" */ \n");
    }

    protected void introPackage(StringBuilder builder, BeanModel model) {
        builder.append("package " + model.getPackageName() + ";\n\n");
    }

    protected void introSuper(StringBuilder builder, BeanModel model) {
        BeanModel superModel = model.getSuperModel();
        String superQueryType = superModel.getPrefix() + superModel.getSimpleName();
        if (!model.getPackageName().equals(superModel.getPackageName())) {
            superQueryType = superModel.getPackageName() + "." + superQueryType;
        }
        if (!superModel.hasEntityFields()) {
            builder.append("    public final " + superQueryType + " _super = new " + superQueryType + "(this);\n\n");
        } else {
            builder.append("    public final " + superQueryType + " _super;\n\n");
        }
    }

    protected void listOfEntity(PropertyModel field, Writer writer) throws IOException {
        String genericTypeName = field.getGenericParameterName(0);
        String typeName = field.getRawParameterName(0);
        this.serialize(field, "PEntityList<" + genericTypeName + "," + field.getQueryTypeName() + ">", writer, "createEntityList", typeName + ".class", field.getQueryTypeName() + ".class");
    }

    protected void listOfEntityAccessor(PropertyModel field, Writer writer) throws IOException {
        String escapedName = field.getEscapedName();
        String queryType = field.getQueryTypeName();
        StringBuilder builder = new StringBuilder();
        builder.append("    public " + queryType + " " + escapedName + "(int index) {\n");
        builder.append("        return " + escapedName + ".get(index);\n");
        builder.append("    }\n\n");
        builder.append("    public " + queryType + " " + escapedName + "(Expr<Integer> index) {\n");
        builder.append("        return " + escapedName + ".get(index);\n");
        builder.append("    }\n\n");
        writer.append(builder.toString());
    }

    protected void listOfSimple(PropertyModel field, Writer writer) throws IOException {
        String genericTypeName = field.getGenericParameterName(0);
        String typeName = field.getRawParameterName(0);
        this.serialize(field, "PComponentList<" + genericTypeName + ">", writer, "createSimpleList", typeName + ".class");
    }

    protected void listOfSimpleAccessor(PropertyModel field, Writer writer) throws IOException {
        String escapedName = field.getEscapedName();
        String valueType = field.getGenericParameterName(0);
        StringBuilder builder = new StringBuilder();
        builder.append("    public PSimple<" + valueType + "> " + escapedName + "(int index) {\n");
        builder.append("        return " + escapedName + ".get(index);\n");
        builder.append("    }\n\n");
        builder.append("    public PSimple<" + valueType + "> " + escapedName + "(Expr<Integer> index) {\n");
        builder.append("        return " + escapedName + ".get(index);\n");
        builder.append("    }\n\n");
        writer.append(builder.toString());
    }

    protected void mapOfEntity(PropertyModel field, Writer writer) throws IOException {
        String keyType = field.getRawParameterName(0);
        String valueType = field.getRawParameterName(1);
        String genericKey = field.getGenericParameterName(0);
        String genericValue = field.getGenericParameterName(1);
        this.serialize(field, "PEntityMap<" + genericKey + "," + genericValue + "," + field.getQueryTypeName() + ">", writer, "createEntityMap", keyType + ".class", valueType + ".class", field.getQueryTypeName() + ".class");
    }

    protected void mapOfEntityAccessor(PropertyModel field, Writer writer) throws IOException {
        String escapedName = field.getEscapedName();
        String queryType = field.getQueryTypeName();
        String keyType = field.getGenericParameterName(0);
        String genericKey = field.getGenericParameterName(0);
        StringBuilder builder = new StringBuilder();
        builder.append("    public " + queryType + " " + escapedName + "(" + keyType + " key) {\n");
        builder.append("        return " + escapedName + ".get(key);\n");
        builder.append("    }\n\n");
        builder.append("    public " + queryType + " " + escapedName + "(Expr<" + genericKey + "> key) {\n");
        builder.append("        return " + escapedName + ".get(key);\n");
        builder.append("    }\n\n");
        writer.append(builder.toString());
    }

    protected void mapOfSimple(PropertyModel field, Writer writer) throws IOException {
        String keyType = field.getRawParameterName(0);
        String valueType = field.getRawParameterName(1);
        String genericKey = field.getGenericParameterName(0);
        String genericValue = field.getGenericParameterName(1);
        this.serialize(field, "PComponentMap<" + genericKey + "," + genericValue + ">", writer, "createSimpleMap", keyType + ".class", valueType + ".class");
    }

    protected void mapOfSimpleAccessor(PropertyModel field, Writer writer) throws IOException {
        String escapedName = field.getEscapedName();
        String genericKey = field.getGenericParameterName(0);
        String genericValue = field.getGenericParameterName(1);
        StringBuilder builder = new StringBuilder();
        builder.append("    public PSimple<" + genericValue + "> " + escapedName + "(" + genericKey + " key) {\n");
        builder.append("        return " + escapedName + ".get(key);\n");
        builder.append("    }\n\n");
        builder.append("    public PSimple<" + genericValue + "> " + escapedName + "(Expr<" + genericKey + "> key) {\n");
        builder.append("        return " + escapedName + ".get(key);\n");
        builder.append("    }\n\n");
        writer.append(builder.toString());
    }

    protected void numericField(PropertyModel field, Writer writer) throws IOException {
        this.serialize(field, "PNumber<" + field.getGenericTypeName() + ">", writer, "createNumber", field.getTypeName() + ".class");
    }

    protected void outro(BeanModel model, Writer writer) throws IOException {
        writer.write("}\n");
    }

    @Override
    public void serialize(BeanModel model, Writer writer) throws IOException {
        this.intro(model, writer);
        for (PropertyModel property : model.getProperties()) {
            switch (property.getTypeCategory()) {
                case STRING: {
                    this.stringField(property, writer);
                    break;
                }
                case BOOLEAN: {
                    this.booleanField(property, writer);
                    break;
                }
                case SIMPLE: {
                    this.simpleField(property, writer);
                    break;
                }
                case COMPARABLE: {
                    this.comparableField(property, writer);
                    break;
                }
                case DATE: {
                    this.dateField(property, writer);
                    break;
                }
                case DATETIME: {
                    this.dateTimeField(property, writer);
                    break;
                }
                case TIME: {
                    this.timeField(property, writer);
                    break;
                }
                case NUMERIC: {
                    this.numericField(property, writer);
                    break;
                }
                case SIMPLECOLLECTION: {
                    this.collectionOfSimple(property, writer);
                    break;
                }
                case ENTITYCOLLECTION: {
                    this.collectionOfEntity(property, writer);
                    break;
                }
                case SIMPLEMAP: {
                    this.mapOfSimple(property, writer);
                    break;
                }
                case ENTITYMAP: {
                    this.mapOfEntity(property, writer);
                    break;
                }
                case SIMPLELIST: {
                    this.listOfSimple(property, writer);
                    break;
                }
                case ENTITYLIST: {
                    this.listOfEntity(property, writer);
                    break;
                }
                case ENTITY: {
                    this.entityField(property, writer);
                }
            }
        }
        this.constructors(model, writer);
        for (PropertyModel property : model.getProperties()) {
            switch (property.getTypeCategory()) {
                case SIMPLEMAP: {
                    this.mapOfSimpleAccessor(property, writer);
                    break;
                }
                case ENTITYMAP: {
                    this.mapOfEntityAccessor(property, writer);
                    break;
                }
                case SIMPLELIST: {
                    this.listOfSimpleAccessor(property, writer);
                    break;
                }
                case ENTITYLIST: {
                    this.listOfEntityAccessor(property, writer);
                }
            }
        }
        this.outro(model, writer);
    }

    protected void serialize(PropertyModel field, String type, Writer writer, String factoryMethod, String ... args) throws IOException {
        BeanModel superModel = field.getBeanModel().getSuperModel();
        StringBuilder value = new StringBuilder();
        if (field.isInherited() && superModel != null) {
            if (!superModel.hasEntityFields()) {
                value.append("_super." + field.getEscapedName());
            }
        } else {
            value.append(factoryMethod + "(\"" + field.getName() + "\"");
            for (String arg : args) {
                value.append(", " + arg);
            }
            value.append(")");
        }
        StringBuilder builder = new StringBuilder();
        if (field.isInherited()) {
            builder.append("    // inherited\n");
        }
        if (value.length() > 0) {
            builder.append("    public final " + type + " " + field.getEscapedName() + " = " + value + ";\n\n");
        } else {
            builder.append("    public final " + type + " " + field.getEscapedName() + ";\n\n");
        }
        writer.append(builder.toString());
    }

    protected void simpleField(PropertyModel field, Writer writer) throws IOException {
        this.serialize(field, "PSimple<" + field.getGenericTypeName() + ">", writer, "createSimple", field.getTypeName() + ".class");
    }

    protected void stringField(PropertyModel field, Writer writer) throws IOException {
        this.serialize(field, "PString", writer, "createString", new String[0]);
    }

    protected void timeField(PropertyModel field, Writer writer) throws IOException {
        this.serialize(field, "PTime<" + field.getGenericTypeName() + ">", writer, "createTime", field.getTypeName() + ".class");
    }
}

