/*
 * Copyright (c) 2009 Mysema Ltd.
 * All rights reserved.
 * 
 */
package com.mysema.query.types.path;

import java.util.HashMap;
import java.util.Map;

import com.mysema.query.types.expr.Expr;

/**
 * PComponentList represents component list paths
 * 
 * @author tiwe
 * 
 * @param <D> component type
 */
@SuppressWarnings("serial")
public class PComponentList<D> extends PComponentCollection<D> implements PList<D> {
    
    private final Map<Integer,PSimple<D>> cache = new HashMap<Integer,PSimple<D>>();
    
    public PComponentList(Class<? super D> type, PathMetadata<?> metadata) {
        super(type, metadata);
    }

    @Override
    public PSimple<D> get(Expr<Integer> index) {
        return new PSimple<D>(type, PathMetadata.forListAccess(this, index));
    }

    @Override
    public PSimple<D> get(int index) {
        if (cache.containsKey(index)){
            return cache.get(index);
        }else{
            PSimple<D> rv = create(index);
            cache.put(index, rv);
            return rv;
        }
    }
    
    private PSimple<D> create(int index){
        return new PSimple<D>(type, PathMetadata.forListAccess(this, index));
    }
}