/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.path;

import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.EBoolean;
import com.mysema.query.types.expr.EMapBase;
import com.mysema.query.types.expr.Expr;
import com.mysema.query.types.operation.OBoolean;
import com.mysema.query.types.operation.Ops;
import com.mysema.query.types.path.PMap;
import com.mysema.query.types.path.PSimple;
import com.mysema.query.types.path.Path;
import com.mysema.query.types.path.PathMetadata;
import com.mysema.query.util.NotEmpty;
import java.util.Map;

public class PComponentMap<K, V>
extends EMapBase<K, V>
implements PMap<K, V> {
    private final Class<K> keyType;
    private final PathMetadata<?> metadata;
    private final Class<V> valueType;
    private final Path<?> root;
    private volatile EBoolean isnull;
    private volatile EBoolean isnotnull;

    public PComponentMap(Class<? super K> keyType, Class<? super V> valueType, PathMetadata<?> metadata) {
        super(Map.class);
        this.keyType = keyType;
        this.valueType = valueType;
        this.metadata = metadata;
        this.root = metadata.getRoot() != null ? metadata.getRoot() : this;
    }

    public PComponentMap(Class<? super K> keyType, Class<? super V> valueType, @NotEmpty String var) {
        this(keyType, valueType, PathMetadata.forVariable(var));
    }

    public PComponentMap(Class<? super K> keyType, Class<? super V> valueType, Path<?> parent, @NotEmpty String property) {
        this(keyType, valueType, PathMetadata.forProperty(parent, property));
    }

    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }

    public boolean equals(Object o) {
        return o instanceof Path ? ((Path)o).getMetadata().equals(this.metadata) : false;
    }

    @Override
    public PSimple<V> get(Expr<K> key) {
        return new PSimple<V>(this.valueType, PathMetadata.forMapAccess(this, key));
    }

    @Override
    public PSimple<V> get(K key) {
        return new PSimple<V>(this.valueType, PathMetadata.forMapAccess(this, key));
    }

    @Override
    public Class<K> getKeyType() {
        return this.keyType;
    }

    @Override
    public PathMetadata<?> getMetadata() {
        return this.metadata;
    }

    @Override
    public Path<?> getRoot() {
        return this.root;
    }

    @Override
    public Class<V> getValueType() {
        return this.valueType;
    }

    @Override
    public int hashCode() {
        return this.metadata.hashCode();
    }

    @Override
    public EBoolean isNotNull() {
        if (this.isnotnull == null) {
            this.isnotnull = OBoolean.create(Ops.IS_NOT_NULL, this);
        }
        return this.isnotnull;
    }

    @Override
    public EBoolean isNull() {
        if (this.isnull == null) {
            this.isnull = OBoolean.create(Ops.IS_NULL, this);
        }
        return this.isnull;
    }

    public EMapBase<K, V> asExpr() {
        return this;
    }
}

