/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.operation;

import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.ENumber;
import com.mysema.query.types.expr.Expr;
import com.mysema.query.types.operation.Operation;
import com.mysema.query.types.operation.Operator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ONumber<OpType extends Number, D extends Number>
extends ENumber<D>
implements Operation<OpType, D> {
    private final List<Expr<?>> args;
    private final Operator<OpType> op;

    public static <O extends Number, D extends Number> ENumber<D> create(Class<? extends D> type, Operator<O> op, Expr<?> ... args) {
        return new ONumber<O, D>(type, op, args);
    }

    ONumber(Class<? extends D> type, Operator<OpType> op, Expr<?> ... args) {
        this(type, op, Arrays.asList(args));
    }

    ONumber(Class<? extends D> type, Operator<OpType> op, List<Expr<?>> args) {
        super(type);
        this.op = op;
        this.args = Collections.unmodifiableList(args);
    }

    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }

    @Override
    public Expr<?> getArg(int i) {
        return this.args.get(i);
    }

    @Override
    public List<Expr<?>> getArgs() {
        return this.args;
    }

    @Override
    public Operator<OpType> getOperator() {
        return this.op;
    }

    @Override
    public ENumber<D> asExpr() {
        return this;
    }
}

